# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, post_load

from common.utils import settlement as settlement_utils
from common.utils.namedtuple import namedtuple_with_defaults
from travel.rasp.morda_backend.morda_backend.serialization.fields import TransportTypeField


SettlementContext = namedtuple_with_defaults('SettlementContext', [
    'transport_type'
])


class SettlementQuerySchema(Schema):
    transport_type = TransportTypeField(load_from='t_type')

    @post_load
    def make_context(self, data):
        return SettlementContext(**data)


def settlement_json(settlement, national_version, language):
    return {
        'id': settlement.id,
        'slug': settlement.slug,
        'title': settlement.L_title(language),
        'title_with_type': settlement.L_title_with_type(language),
        'title_genitive': settlement.L_title(lang=language, case='genitive', fallback=False),
        'timezone': settlement.get_tz_name(),
        'region_id': settlement.region_id,
        'blablacar_title': settlement.L_title_with_full_geography(national_version, language),
        'ymap_url': settlement_utils.get_ymap_url(settlement, national_version, language),
        'suburban_zone': settlement_suburban_zone_json(settlement),
        'key': settlement.point_key,
    }


def settlement_suburban_zone_json(settlement):
    return {
        'id': settlement.suburban_zone.id,
        'settlement': {
            'id': settlement.suburban_zone.settlement.id
        }
    } if settlement.suburban_zone else None
