# -*- coding: utf-8 -*-

from travel.rasp.morda_backend.morda_backend.settlement.serialization import station_helpers


def station_json(station, status_json, language):
    return {
        'id': station.id,
        'title': station.L_popular_title(lang=language),
        'popular_title': station.L_popular_title(lang=language),
        't_type': station.t_type.code,
        'is_metro': station.is_metro,
        'majority': station_helpers.station_majority_json(station),
        'station_type': station_helpers.station_type_json(station, language),
        'page_type': station.page_type,
        'main_subtype': station.main_subtype,
        'status': status_json,
        'aeroexpress': station_helpers.station_aeroexpress_json(station)
    }
