# -*- coding: utf-8 -*-

from common.models.geo import StationType
from common.models.transport import TransportType


def station_majority_json(station):
    return {
        'id': station.majority.id,
        'code': station.majority.code
    } if station.majority else None


def station_type_json(station, language):
    station_type = station.station_type

    return {
        'id': station_type.id,
        # костыль пока на морде используется захардкоженый несуществующий код 'station_without_type'
        # https://github.yandex-team.ru/rasp/morda_front/blob/dev/common/lib/prepareStationsForIndexPage.js#L120
        'code': station_type.code if station_type.id != StationType.UNKNOWN_ID else 'station_without_type',
        'title': station_type.L_title(lang=language).capitalize()
    } if station_type else None


def station_aeroexpress_json(station):
    return {
        'settlement_id': station.settlement.id
    } if station.t_type.id == TransportType.PLANE_ID and station.has_aeroexpress and station.settlement else None
