# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from marshmallow import Schema, fields


class TrainPopularSettlementSchema(Schema):
    id = fields.Integer()
    point_key = fields.String(dump_to='key')
    slug = fields.String()
    title = fields.Function(lambda obj: obj.L_title())
    direction_title = fields.Method('_title_with_direction', dump_to='directionTitle')

    def _title_with_direction(self, settlement):
        destination_direction = self.context.get('destination_direction')
        if destination_direction in ['from', 'to']:
            return getattr(settlement, 'L_title_phrase_{}'.format(destination_direction))()
        return None


class TrainPopularDirectionsSchema(Schema):
    departure_city = fields.Nested(TrainPopularSettlementSchema(context={'destination_direction': 'from'}),
                                   dump_to='departureCity')
    arrival_cities = fields.Nested(TrainPopularSettlementSchema(context={'destination_direction': 'to'}),
                                   dump_to='arrivalCities', many=True)
