# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from collections import defaultdict

from common.utils.settlement import get_main_stations
from travel.rasp.morda_backend.morda_backend.station.data_layer.page_type import get_station_by_id, StationPageType


def get_station_city_stations(context):
    """
    Другие станции города, которому принадлежит станция
    """
    settlement = get_station_by_id(context['station_id']).settlement

    if not settlement:
        return {'settlement': None, 'cityStations': {}}

    stations = get_main_stations(settlement, t_type_id=None)

    stations_by_t_types = defaultdict(dict)
    for station in stations:
        t_type_code = 'train' if station.t_type.code == 'suburban' else station.t_type.code
        stations_by_t_types[t_type_code][station.id] = station

    return {
        'settlement': {
            'title': settlement.L_title(),
            'titleGenitive': settlement.L_title(case='genitive'),
        },
        'cityStations': {
            t_type_code: _get_t_type_stations_json_data(stations_by_t_types[t_type_code])
            for t_type_code in stations_by_t_types
        }
    }


def _get_t_type_stations_json_data(stations_dict):
    """
    Получение списка станций города в формате JSON
    """
    stations_list = list(stations_dict.values())
    stations_list.sort(key=lambda s: s.L_popular_title().lower())
    result = []
    for station in stations_list:
        page_type = StationPageType(station, None)
        station_data = {
            'id': station.id,
            'title': station.L_popular_title(),
            'mainSubtype': page_type.main_subtype,
            'subtypes': page_type.subtypes
        }
        result.append(station_data)

    return result
