# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType
from common.models.geo import Station, StationTerminal


class FindStationError(Exception):
    pass


def get_station_by_id(station_id):
    try:
        return Station.objects.get(id=station_id)
    except Station.DoesNotExist:
        raise FindStationError('Станции с id {} нет в базе'.format(station_id))


class StationPageType(object):
    """
    Класс для определения информации о типах транспорта станции
    """
    def __init__(self, station, page_subtype):
        self.station = station

        self.page_type = station.page_type
        self.subtypes = station.subtypes
        self.main_subtype = station.main_subtype
        self.current_subtype = None  # текущий подтип страницы
        self.t_type_code = None  # основной тип транспорта для текущего подтипа страницы
        self.not_enough_info = self.station.is_foreign() and self.station.t_type_id != TransportType.PLANE_ID

        if not page_subtype:
            self.current_subtype = self.main_subtype
        elif page_subtype in self.subtypes:
            self.current_subtype = page_subtype
        elif self.main_subtype == 'suburban' and page_subtype == 'tablo':  # fastfix RASPFRONT-9242
            self.current_subtype = 'tablo'

        if self.current_subtype in ['train', 'suburban', 'plane']:
            self.t_type_code = self.current_subtype
        elif self.current_subtype == 'schedule':
            self.t_type_code = self.page_type

        if self.station.t_type.id == TransportType.PLANE_ID:
            self._make_terminals()

    def _make_terminals(self):
        """
        Список терминалов для аэропорта
        """
        terminals = [terminal for terminal in StationTerminal.objects.filter(station_id=self.station.id)]
        if terminals:
            self.terminals = terminals
