# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType
from travel.rasp.morda_backend.morda_backend.data_layer.popular_directions import (
    PopularPoint, get_point_popular_directions
)
from travel.rasp.morda_backend.morda_backend.station.data_layer.page_type import StationPageType, get_station_by_id


def get_station_popular_directions(context):
    """
    Популярные направления поиска для станции
    """
    station = get_station_by_id(context.station_id)
    page_type = StationPageType(station, context.subtype)
    station = page_type.station
    t_type = TransportType.objects.get(code=page_type.t_type_code) if page_type.t_type_code else None

    from_directions = get_point_popular_directions('from', station, t_type, context.limit, search_type='all')
    to_directions = get_point_popular_directions('to', station, t_type, context.limit, search_type='all')

    result = {
        't_type_code': page_type.t_type_code,
        'station': _get_station_popular_point(station, from_directions, to_directions)
    }

    result.update({
        'from_points': [popular_segment.outer_point for popular_segment in from_directions],
        'to_points': [popular_segment.outer_point for popular_segment in to_directions]
    })
    return result


def _get_station_popular_point(station, from_directions, to_directions):
    if len(from_directions) > 0:
        return from_directions[0].inner_point
    elif len(to_directions) > 0:
        return to_directions[0].inner_point
    return PopularPoint(station, station, 'to')
