# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.morda_backend.morda_backend.station.data_layer.bus import BusStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.page_context import StationPageContext
from travel.rasp.morda_backend.morda_backend.station.data_layer.page_type import StationPageType, get_station_by_id
from travel.rasp.morda_backend.morda_backend.station.data_layer.plane import PlaneStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.suburban import SuburbanStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.tablo import TabloStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.train import TrainStationForPage


def get_station_quick(context):
    """
    Быстрое получение информации по типам и подтипам станции
    """
    station = get_station_by_id(context.station_id)
    station_transport = StationPageType(station, context.subtype)
    return station_transport


def get_station(context, now_dt):
    """
    Получение данных для главной ручки станции
    """
    station = get_station_by_id(context.station_id)
    station_page_type = StationPageType(station, context.subtype)
    page_type = station_page_type.page_type
    current_subtype = station_page_type.current_subtype

    page_context = StationPageContext(station_page_type.station, context.date, context.event, now_dt)

    if page_type == 'train':
        if current_subtype == 'suburban':
            st_for_page = SuburbanStationForPage(station_page_type, context.country)
            st_for_page.load_threads(page_context, context.direction)
        elif current_subtype == 'tablo':
            st_for_page = TabloStationForPage(station_page_type, context.country)
            st_for_page.load_threads(page_context)
        else:
            st_for_page = TrainStationForPage(station_page_type, context.country)
            st_for_page.load_threads(page_context)

    elif page_type == 'plane':
        st_for_page = PlaneStationForPage(station_page_type, context.country)
        st_for_page.load_threads(page_context, context.time_after, context.time_before)

    else:
        st_for_page = BusStationForPage(station_page_type, context.country)
        st_for_page.load_threads(page_context)

    st_for_page.threads_smart_sort()
    st_for_page.make_companies()
    st_for_page.make_teasers(context.is_mobile)
    return st_for_page


def get_station_stops(context, now_dt):
    station = get_station_by_id(context.station_id)
    station_page_type = StationPageType(station, 'schedule')

    page_context = StationPageContext(
        station_page_type.station, context.date, context.event, now_dt
    )

    return_for_types = {t for t in context.return_for_types if t in {'bus', 'water'}}
    if station_page_type.t_type_code not in return_for_types:
        return {'stops': []}

    st_for_page = BusStationForPage(station_page_type, context.country)
    st_for_page.load_threads(page_context)
    st_for_page.make_stops()

    return st_for_page
