# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.xgettext.common import get_schedule_autotext
from stationschedule import get_schedule_class

from travel.rasp.morda_backend.morda_backend.station.data_layer.base_station import BaseStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.base_station_thread import StationRaspDBThread


class SuburbanStationForPage(BaseStationForPage):
    """
    https://st.yandex-team.ru/RASPFRONT-6852
    Страница выдачи электричек для ЖД станции
    """
    def __init__(self, station_page_type, country):
        super(SuburbanStationForPage, self).__init__(station_page_type, country)

    def load_threads(self, page_context, direction):
        """
        Формирование списка ниток станции
        """
        self.page_context = page_context

        # Формирование класса формирования расписаний (из station_schedule)
        schedule_cls = get_schedule_class(self.station, schedule_type='suburban', t_type_code='suburban')
        if page_context.event == 'departure':
            schedule = schedule_cls(self.station, requested_direction=direction)
            schedule_for_directions = schedule
        else:
            schedule = schedule_cls(self.station, requested_direction='all', event='arrival')
            # Список направлений можно получить только запросив расписание с event='departure'
            schedule_for_directions = schedule_cls(self.station, requested_direction='all')

        self._make_directions(schedule_for_directions, page_context.event)

        # Получение графиков расписаний
        _, next_plan = schedule.current_next_plans(page_context.today)

        # Построение расписания
        if not page_context.is_all_days:
            schedule.build(schedule_date=page_context.date)
        else:
            schedule.build()

        self.schedule_routes = schedule.schedule_routes
        self.threads = []
        for schedule_route in self.schedule_routes:
            if schedule_route.event == page_context.event:
                self.threads.append(
                    SuburbanStationThread(schedule_route, self, next_plan)
                )

        self._make_dynamic_platforms()

    def _make_dynamic_platforms(self):
        """
        Подгрузка динамических платформ
        ToDo Должно быть сделано в рамках https://st.yandex-team.ru/RASPFRONT-7682
        """
        pass

    def _make_directions(self, schedule, event):
        """
        Получение списка направлений и текущего направления
        """
        directions = []
        directions_list = schedule.direction_code_title_count_list
        for direction in directions_list:
            direction_dict = {'code': direction[0], 'title': direction[1]}
            if direction_dict['code'] == 'all':
                directions.insert(0, direction_dict)
            elif direction_dict['code'] != 'arrival':
                directions.append(direction_dict)

        self.station_properties['directions'] = directions
        if event == 'departure':
            self.page_context.direction_code = schedule.direction_code


class SuburbanStationThread(StationRaspDBThread):
    """
    Нитка электрички для страницы станции
    """
    def __init__(self, schedule_route, st_for_page, next_plan):
        super(SuburbanStationThread, self).__init__(schedule_route, st_for_page, next_plan)

        if self.schedule_route.thread.schedule_plan:
            self.schedule_plan = schedule_route.thread.schedule_plan.code

        self.is_express = schedule_route.thread.is_express
        self.is_aeroexpress = schedule_route.thread.is_aeroexpress
        self.platform = schedule_route.rtstation.L_platform()
        if self.event == 'departure':
            self._make_stops(schedule_route)

    def _make_stops(self, schedule_route):
        """
        Формирование списка остановок нитки
        """
        stops_text = schedule_route.schedule.L_stops()

        if stops_text == get_schedule_autotext('suburban_stops.everywhere', self.st_for_page.language):
            self.stops = {'type': 'everywhere'}  # останавливается везде
        elif stops_text in {'', get_schedule_autotext('suburban_stops.nonstop', self.st_for_page.language)}:
            self.stops = {'type': 'nonstop'}  # не останавливается нигде
        else:
            self.stops = {'type': 'stops', 'text': stops_text}
