# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from stationschedule.views import station_schedule

from travel.rasp.morda_backend.morda_backend.station.data_layer.base_station import BaseStationForPage
from travel.rasp.morda_backend.morda_backend.station.data_layer.base_station_thread import StationRaspDBThread


class TrainStationForPage(BaseStationForPage):
    """
    https://st.yandex-team.ru/RASPFRONT-6852
    Страница выдачи поездов для ЖД станции
    """
    def __init__(self, station_page_type, country):
        super(TrainStationForPage, self).__init__(station_page_type, country)

    def load_threads(self, page_context):
        """
        Формирование списка ниток станции
        """
        self.page_context = page_context

        # Формирование расписания по станции с использованием station_schedule

        if hasattr(page_context, 'date'):
            schedule = station_schedule(
                self.station, event=page_context.event, schedule_date=page_context.date, t_type_code='train'
            )
        else:
            schedule = station_schedule(self.station, event=page_context.event, t_type_code='train')
        self.schedule_routes = schedule.schedule_routes

        self.threads = []
        for schedule_route in self.schedule_routes:
            self.threads.append(TrainStationThread(schedule_route, self))


class TrainStationThread(StationRaspDBThread):
    """
    Нитка поезда для страницы станции
    """
    def __init__(self, schedule_route, st_for_page):
        super(TrainStationThread, self).__init__(schedule_route, st_for_page)

        if schedule_route.thread.deluxe_train:
            self.deluxe_train_title = schedule_route.thread.deluxe_train.L_title_short()

        train_number = schedule_route.rtstation.train_number
        if train_number:
            self.number = train_number

        self.platform = schedule_route.rtstation.L_platform()
