# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields

from travel.rasp.morda_backend.morda_backend.serialization.teasers import SelectedTeasers


class TerminalSchema(Schema):
    id = fields.Integer()
    name = fields.String()
    is_domestic = fields.Boolean(dump_to='isDomestic')
    is_international = fields.Boolean(dump_to='isInternational')


class StationPageTypeSchema(Schema):
    page_type = fields.String(dump_to='type')
    subtypes = fields.List(fields.String)
    main_subtype = fields.String(dump_to='mainSubtype')
    current_subtype = fields.String(dump_to='currentSubtype')
    terminals = fields.Nested(TerminalSchema, many=True)
    not_enough_info = fields.Boolean(dump_to='notEnoughInfo')


class PopularPointSchema(Schema):
    point_key = fields.String(dump_to='key')
    title = fields.String()
    slug = fields.String()


class PopularDirectionsSchema(Schema):
    t_type_code = fields.String(dump_to='searchTransportType')
    station = fields.Nested(PopularPointSchema)
    from_points = fields.Nested(PopularPointSchema, dump_to='from', many=True)
    to_points = fields.Nested(PopularPointSchema, dump_to='to', many=True)


class StationSettlementSchema(Schema):
    id = fields.Integer()
    slug = fields.String()
    title = fields.String()
    title_genitive = fields.String(dump_to='titleGenitive')


class WayToAirportSchema(Schema):
    from_point_key = fields.String(dump_to='fromPointId')
    to_point_key = fields.String(dump_to='toPointId')
    from_point_slug = fields.String(dump_to='fromSlug')
    to_point_slug = fields.String(dump_to='toSlug')
    link_title = fields.String(dump_to='linkTitle')
    way_type = fields.String(dump_to='wayType')


class SuburbanDirectionSchema(Schema):
    code = fields.String()
    title = fields.String()


class StationPropertiesSchema(Schema):
    id = fields.Int()
    title = fields.String()
    title_genitive = fields.String(dump_to='titleGenitive', default=None)
    full_title = fields.String(dump_to='fullTitle')
    full_title_genitive = fields.String(dump_to='fullTitleGenitive')
    full_title_dative = fields.String(dump_to='fullTitleDative')
    has_popular_title = fields.Boolean(dump_to='hasPopularTitle')
    address = fields.String()
    phones = fields.List(fields.String)
    subway = fields.String(default=None)
    longitude = fields.Float()
    latitude = fields.Float()
    settlement = fields.Nested(StationSettlementSchema)
    station_type = fields.String(dump_to='stationType')

    trusted = fields.Boolean()
    iata_code = fields.String(dump_to='iataCode')
    way_to_airport = fields.Nested(WayToAirportSchema, dump_to='wayToAirport')
    directions = fields.Nested(SuburbanDirectionSchema, many=True)


class WhenSchema(Schema):
    date = fields.Date()
    special = fields.String()
    dt_after = fields.Function(lambda obj: obj.dt_after.isoformat(), dump_to='dtAfter')
    dt_before = fields.Function(lambda obj: obj.dt_before.isoformat(), dump_to='dtBefore')


class PageContextSchema(Schema):
    event = fields.String()
    when = fields.Nested(WhenSchema)
    dt_now = fields.Function(lambda obj: obj.dt_now.replace(microsecond=0).isoformat(), dump_to='dtNow')

    direction_code = fields.String(dump_to='directionCode')


class EventDateTimeSchema(Schema):
    time = fields.String()
    datetime = fields.LocalDateTime()


class TransportSubTypeSchema(Schema):
    code = fields.String()
    title = fields.String()


class ThreadStopsSchema(Schema):
    text = fields.String()
    type = fields.String()


class IntervalThreadSchema(Schema):
    begin_time = fields.String(dump_to='beginTime')
    end_time = fields.String(dump_to='endTime')
    density = fields.String()


class ThreadSchema(Schema):
    canonical_uid = fields.String(dump_to='canonicalUid')
    departure_from = fields.LocalDateTime(dump_to='departureFrom')
    departure = fields.Date()

    event_date_and_time = fields.Nested(EventDateTimeSchema, dump_to='eventDt')
    schedule_plan = fields.String(dump_to='schedulePlan')

    t_type = fields.String(dump_to='transportType')
    title = fields.String()
    number = fields.String()
    comment = fields.String()

    is_express = fields.Boolean(dump_to='isExpress')
    is_aeroexpress = fields.Boolean(dump_to='isAeroExpress')
    deluxe_train_title = fields.String(dump_to='deluxeTrainTitle')
    transport_subtype = fields.Nested(TransportSubTypeSchema, dump_to='transportSubtype')
    company_id = fields.Integer(dump_to='companyId')

    days_text = fields.String(dump_to='daysText')
    run_days_text = fields.String(dump_to='runDaysText')
    except_days_text = fields.String(dump_to='exceptDaysText')
    stops = fields.Nested(ThreadStopsSchema)
    platform = fields.String()

    model_title = fields.String(dump_to='modelTitle')


class PlaneRouteStation(Schema):
    iata_code = fields.String(dump_to='iataCode')
    title = fields.String()
    settlement = fields.String()


class PlaneNumber(Schema):
    number = fields.String()
    company_id = fields.Integer(dump_to='companyId')


class PlaneStatus(Schema):
    actual_terminal = fields.String(dump_to='actualTerminal')
    gate = fields.String()
    check_in_desks = fields.String(dump_to='checkInDesks')
    baggage_carousels = fields.String(dump_to='baggageCarousels')

    status = fields.String()
    actual_dt = fields.String(dump_to='actualDt')
    diverted = fields.Nested(PlaneRouteStation)


class PlaneThreadSchema(PlaneNumber):
    avia_link = fields.String(dump_to='aviaLink')
    event_date_and_time = fields.Nested(EventDateTimeSchema, dump_to='eventDt')
    t_type = fields.String(dump_to='transportType')
    route_stations = fields.Nested(PlaneRouteStation, dump_to='routeStations', many=True)
    codeshares = fields.Nested(PlaneNumber, many=True)
    terminal = fields.String()

    days_text = fields.String(dump_to='daysText')
    status = fields.Nested(PlaneStatus)
    is_supplement = fields.Boolean(dump_to='isSupplement')


class CompanySchema(Schema):
    id = fields.Integer()
    title = fields.String()
    short_title = fields.String(dump_to='shortTitle')
    url = fields.String()
    hidden = fields.Bool()
    icon = fields.String()


class BaseStationSchema(Schema):
    page_type = fields.Nested(StationPageTypeSchema, dump_to='pageType')
    station_properties = fields.Nested(StationPropertiesSchema, dump_to='station')
    teasers = fields.Nested(SelectedTeasers)
    page_context = fields.Nested(PageContextSchema, dump_to='context')
    companies = fields.Nested(CompanySchema, many=True)


class ScheduleThreadSchema(Schema):
    canonical_uid = fields.String(dump_to='canonicalUid')
    departure_from = fields.LocalDateTime(dump_to='departureFrom')
    interval = fields.Nested(IntervalThreadSchema)


class ScheduleItemSchema(Schema):
    days_text = fields.String(dump_to='daysText')
    run_days_text = fields.String(dump_to='runDaysText')
    except_days_text = fields.String(dump_to='exceptDaysText')

    threads = fields.Nested(ScheduleThreadSchema, many=True)


class ScheduleBlockSchema(Schema):
    title = fields.String()
    number = fields.String()
    t_type = fields.String(dump_to='transportType')
    comment = fields.String()
    company_id = fields.Integer(dump_to='companyId')

    schedule = fields.Nested(ScheduleItemSchema, many=True, dump_to='schedule')


class ScheduleSchema(BaseStationSchema):
    schedule_blocks = fields.Nested(ScheduleBlockSchema, many=True, dump_to='scheduleBlocks')


class StationSchema(BaseStationSchema):
    threads = fields.Nested(ThreadSchema, many=True)


class AirportSchema(BaseStationSchema):
    threads = fields.Nested(PlaneThreadSchema, many=True)


class ScheduleStopsSchemaItem(Schema):
    id = fields.Int()
    title = fields.String()
    settlement = fields.String()
    majority = fields.Int()

    threads = fields.List(fields.String, many=True)


class ScheduleStopsSchema(Schema):
    stops = fields.Nested(ScheduleStopsSchemaItem, many=True)
