# coding: utf-8

from __future__ import unicode_literals

from django.conf import settings
from django.utils.encoding import smart_bytes

from common.utils import marketstat
from travel.rasp.library.python.common23.date import environment
from travel.rasp.morda_backend.morda_backend.tariffs.bus.service import make_ybus_tariff_keys, KEY_TEMPLATES_ALL_DAYS

yt_dynamic_tariffs_log = marketstat.DsvSimpleLog(settings.DINAMIC_TARIFFS_LOG)


def log_segment(segment, national_version):
    timestamp = environment.now_aware()
    data = {
        'timestamp': timestamp.strftime("%Y-%m-%d %H:%M:%S"),
        'timezone': timestamp.strftime('%z'),
        'class_bus_price': segment.price,
        'class_bus_seats': segment.seats,
        'arrival': segment.arrival,
        'departure': segment.departure,
        'date_forward': segment.departure.strftime('%Y-%m-%d'),
        'duration': segment.get_duration(),
        'route_uid': segment.number,
        'object_from_id': segment.station_from.id,
        'object_from_title': segment.station_from.L_title(),
        'object_from_type': 'Station',
        'object_to_id': segment.station_to.id,
        'object_to_title': segment.station_to.L_title(),
        'object_to_type': 'Station',
        'type': 'bus',
        'adults': '1',
        'tskv_format': 'rasp-tariffs-log',
        'partner': 'YBus',
        'key': ', '.join(make_ybus_tariff_keys(segment, KEY_TEMPLATES_ALL_DAYS)),
        'national_version': national_version
    }
    data = {smart_bytes(k): smart_bytes(v) for k, v in data.items()}
    yt_dynamic_tariffs_log.log(data)
