# coding: utf8

from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.tariffs.bus import price_logging
from travel.rasp.morda_backend.morda_backend.tariffs.bus.serialization import BusQuerySchema, ResponseSchema
from travel.rasp.morda_backend.morda_backend.tariffs.bus.service import collect_yandex_buses_results, use_settlement_keys


@api_view(['GET'])
def tariffs(request):
    """
    Поиск цен от Яндекс.Автобусов.
    Пример запроса Питер - Москва:
    /ru/segments/bus-tariffs/?pointFrom=c2&pointTo=c213&date=2016-05-10&national_version=ru
    """
    ybus_query, errors = BusQuerySchema().load(request.GET)
    if errors:
        return Response({
            'errors': errors
        })

    segments, querying = collect_yandex_buses_results(ybus_query.point_from, ybus_query.point_to, ybus_query.dates, ybus_query.bus_settlement_keys)

    for segment in segments:
        price_logging.log_segment(segment, ybus_query.national_version)

    dump_context = {'bus_settlement_keys': use_settlement_keys(context=ybus_query)}

    return Response(ResponseSchema(strict=True, context=dump_context).dump({
        'segments': segments,
        'querying': querying
    }).data)
