# -*- coding: utf-8 -*-

from marshmallow import Schema, fields

from common.serialization.common_schemas import PriceSchema
from common.serialization.fields import DictNestedField, DictField
from travel.rasp.morda_backend.morda_backend.serialization.fields import FlagField
from travel.rasp.morda_backend.morda_backend.serialization.segment import RaspDBSegmentSchema


class OrderRequest(Schema):
    http_method = fields.String(dump_to='httpMethod')
    url = fields.String()
    params = DictField(fields.String())
    headers = DictField(fields.String())


class TariffSchema(Schema):
    price = fields.Nested(PriceSchema)
    seats = fields.Integer()
    order_url = fields.String(dump_to='orderUrl')
    partner_order_request = fields.Nested(OrderRequest, dump_to='partnerOrderRequest')
    deep_url = fields.String(dump_to='deepUrl')
    several_prices = FlagField(dump_to='severalPrices')


class SupplierSchema(Schema):
    code = fields.String()
    logo = fields.String()


class TariffsSchema(Schema):
    key = fields.String()
    classes = DictNestedField(TariffSchema)
    supplier = fields.Nested(SupplierSchema)


class SegmentTariffsSchema(Schema):
    classes = DictNestedField(TariffSchema)
    electronic_ticket = FlagField(dump_to='electronicTicket')
    partner = fields.String()


class TariffsSegmentSchema(RaspDBSegmentSchema):
    key = fields.String()
    number = fields.Function(lambda s: s.number if getattr(s, 'show_number', True) else '')
    original_number = fields.String(dump_to='originalNumber')
    tariffs = fields.Nested(SegmentTariffsSchema)
