# -*- coding: utf-8 -*-

from datetime import timedelta


def can_buy_from(departure, now, order_data):
    try:
        max_days_from_now = int(order_data['day_sale'])
    except (KeyError, ValueError):
        return False

    return timedelta(hours=2) < departure - now < timedelta(days=max_days_from_now)
