# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from travel.rasp.morda_backend.morda_backend.tariffs.static.partners.helpers import get_number_of_days_to_departure


def can_buy_from(departure, now, order_data):
    return timedelta(hours=4, minutes=5) < departure - now < timedelta(days=30)


def get_order_request(departure, now, order_data):
    return dict(http_method='POST',
                url='http://www.donbilet.ru/main',
                params={'pfrom': order_data['station_from_code'],
                        'pto': order_data['station_to_code'],
                        'pdate': get_number_of_days_to_departure(now, departure)},
                headers={'Content-Type': 'text/html; charset=utf-8'})
