# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function


def can_buy_from(departure, now, order_data):
    if 'etraffic_races' not in order_data:
        return False
    departure_str = departure.strftime('%Y-%m-%d %H:%M:%S')
    race = order_data['etraffic_races'].get(departure_str)
    return race


def get_order_request(departure, now, order_data):
    departure_str = departure.strftime('%Y-%m-%d %H:%M:%S')
    return dict(http_method='GET',
                url='http://e-traffic.ru/purchase',
                params={'depot': order_data['depot'],
                        'race': order_data['etraffic_races'].get(departure_str),
                        'station': order_data['to_code'],
                        'date': departure_str})


def add_fee(tariff):
    # RASPFRONT-8538 Добавлять 7% к ценам Е-траффика
    return tariff * 1.07
