# coding: utf-8


def get_number_of_days_to_departure(now_aware, departure_dt):
    """
    :param now_aware: Дата-время сейчас с указанием временной зоны.
    :param departure_dt: Дата-время отправления во временной зоне станции отправления (с указанием временной зоны).
    :return: Количество дней до отправления во временной зоне станции отправления.
    """
    local_now_date = now_aware.astimezone(departure_dt.tzinfo).date()
    return (departure_dt.date() - local_now_date).days
