# coding: utf-8

from datetime import timedelta

from travel.rasp.morda_backend.morda_backend.tariffs.static.partners.helpers import get_number_of_days_to_departure


ORDER_INFORMATION_BY_GROUP_CODE = {
    'chelyabinsk': {
        'sale_stop_hours': 1,
        'sale_start_days': 10,
    },
    'nizhnevartovsk': {
        'sale_stop_hours': 1,
        'sale_start_days': 10,
    },
    'kursk': {
        'sale_stop_hours': 1,
        'sale_start_days': None,
    },
}


def can_buy_from(departure_dt, now_aware, order_data):
    group_code = order_data.get('group_code')
    order_info = ORDER_INFORMATION_BY_GROUP_CODE.get(group_code)
    if not order_info:
        return False

    sale_stop_hours = order_info.get('sale_stop_hours')
    sale_start_days = order_info.get('sale_start_days')

    too_late = False
    if sale_stop_hours is not None:
        too_late = departure_dt <= now_aware + timedelta(hours=sale_stop_hours)

    too_early = False
    if sale_start_days is not None:
        too_early = get_number_of_days_to_departure(now_aware, departure_dt) > sale_start_days

    return (not too_early) and (not too_late)
