# coding: utf-8

from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.tariffs.static.serialization import StaticTariffsQuerySchema, StaticTariffsResponseSchema
from travel.rasp.morda_backend.morda_backend.tariffs.static.service import get_static_tariffs, get_static_min_tariffs


@api_view(['GET'])
def static_tariffs(request):
    """
    Поиск тарифов.
    """
    query, errors = StaticTariffsQuerySchema().load(request.GET)
    if errors:
        return Response({
            'errors': errors
        })

    tariffs = list(get_static_tariffs(query))
    return Response(
        StaticTariffsResponseSchema().dump({
            'tariffs': tariffs
        }).data)


@api_view(['GET'])
def min_static_tariffs(request):
    """
    Поиск тарифов.
    """
    query, errors = StaticTariffsQuerySchema().load(request.GET)
    if errors:
        return Response({
            'errors': errors
        })

    min_tariffs = get_static_min_tariffs(query)
    return Response(StaticTariffsResponseSchema().dump({'tariffs': min_tariffs}).data)
