# coding: utf-8

from marshmallow import Schema, fields

from common.serialization.common_schemas import PriceSchema
from common.serialization.fields import DictNestedField
from common.serialization.schema import CachingSchema
from travel.rasp.morda_backend.morda_backend.serialization.schema_bases import PointsQuerySchema


class SuburbanQuerySchema(PointsQuerySchema):
    pass


class SuburbanPriceSchema(CachingSchema, PriceSchema):
    def get_cache_key(self, obj):
        return '{} {}'.format(
            obj.value if hasattr(obj, 'value') else obj['value'],
            obj.currency if hasattr(obj, 'currency') else obj.get('currency')
        )


class SuburbanTariffSchema(Schema):
    price = fields.Nested(SuburbanPriceSchema)
    title = fields.Function(lambda obj: _choose_type(obj).L_title())
    description = fields.Function(lambda obj: _choose_type(obj).L_description())
    order = fields.Function(lambda obj: _choose_type(obj).order)
    url = fields.Function(lambda obj: _choose_type(obj).link)
    is_main = fields.Function(lambda obj: _choose_type(obj).is_main, dump_to='isMain')


def _choose_type(obj):
    return obj.replace_tariff_type if obj.replace_tariff_type else obj.type


class SuburbanCategoriesSchema(Schema):
    usual = fields.Nested(SuburbanTariffSchema, many=True)
    special = fields.Nested(SuburbanTariffSchema, many=True)
    season_ticket = fields.Nested(SuburbanTariffSchema, many=True, dump_to='seasonTicket')


class SuburbanTariffsSchema(Schema):
    key = fields.String()
    classes = DictNestedField(SuburbanTariffSchema)
    suburban_categories = fields.Nested(SuburbanCategoriesSchema, dump_to='suburbanCategories')


class SuburbanTariffsGroupSchema(Schema):
    id = fields.Integer()
    station_from_id = fields.Integer(dump_to='stationFromId')
    station_to_id = fields.Integer(dump_to='stationToId')
    categories = fields.Nested(SuburbanCategoriesSchema)
    title = fields.String()


class SuburbanResponseSchema(Schema):
    tariffs = fields.Nested(SuburbanTariffsSchema, many=True)
    groups = fields.Nested(SuburbanTariffsGroupSchema, many=True)
