# coding: utf-8
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.tariffs.suburban.serialization import SuburbanResponseSchema, SuburbanQuerySchema
from travel.rasp.morda_backend.morda_backend.tariffs.suburban.service import get_suburban_tariffs


@api_view(['GET'])
def suburban(request):
    """
    Поиск тарифов для электирчек.
    """
    query, errors = SuburbanQuerySchema().load(request.GET)
    if errors:
        return Response({
            'errors': errors
        })

    tariffs, groups = get_suburban_tariffs(**query)
    return Response(SuburbanResponseSchema().dump({
        'groups': groups,
        'tariffs': tariffs
    }).data)
