# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings
from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.thread.data_layer import FindThreadError, get_thread, get_thread_map
from travel.rasp.morda_backend.morda_backend.thread.serialization import ResponseSchema, ThreadContextQuerySchema


log = logging.getLogger(__name__)


@api_view(['GET'])
def thread(request):
    """
    Информация о нитке.
    /ru/thread/?uid=empty_10_f9600183t9600183_134&country=RU&departure=2019-08-17
    """
    context, errors = ThreadContextQuerySchema().load(request.GET)
    if errors:
        return Response({'result': {}, 'errors': errors}, status=status.HTTP_400_BAD_REQUEST)

    try:
        thread_data = get_thread(context)
    except FindThreadError as ex:
        return Response({'result': {}, 'errors': [ex.message]}, status=status.HTTP_404_NOT_FOUND)

    data, errors = ResponseSchema().dump(thread_data)
    return Response({'result': data, 'errors': errors}, status=status.HTTP_200_OK)


@api_view(['GET'])
def thread_map(request):
    """
    Информация для отрисовки карты нитки с помощью Яндекс.Карты
    /ru/thread/map/?uid=empty_10_f9600183t9600183_134&country=RU&departure=2019-08-17
    """
    context, errors = ThreadContextQuerySchema().load(request.GET)
    if errors:
        return Response({'result': {}, 'errors': errors}, status=status.HTTP_400_BAD_REQUEST)

    if not settings.PRELOAD_MAPPING_GEOMETRY:
        return Response({'result': {}, 'errors': ['This instance is not for geometry requests']},
                        status=status.HTTP_404_NOT_FOUND)

    try:
        map_data = get_thread_map(context)
    except FindThreadError as ex:
        return Response({'result': {}, 'errors': [ex.message]}, status=status.HTTP_404_NOT_FOUND)

    if not map_data:
        return Response({'result': {}, 'errors': ['Cannot draw a map for the requested thread']},
                        status=status.HTTP_404_NOT_FOUND)
    else:
        return Response({'result': map_data, 'errors': {}}, status=status.HTTP_200_OK)
