# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields


class TransportRequestSchema(Schema):
    country = fields.String()


class TransportStationSchema(Schema):
    title = fields.String()
    id = fields.Integer()
    page_type = fields.String(dump_to='pageType')
    main_subtype = fields.String(dump_to='mainSubtype')


class TransportCitySchema(Schema):
    title = fields.String()
    slug = fields.String()
    station_id = fields.Integer(dump_to='stationId')
    page_type = fields.String(dump_to='pageType')
    main_subtype = fields.String(dump_to='mainSubtype')


class TransportMainCitySchema(Schema):
    slug = fields.String()
    title = fields.String()
    title_genitive = fields.String(dump_to='titleGenitive')
    stations = fields.Nested(TransportStationSchema, many=True)


class TransportCountrySchema(Schema):
    code = fields.String()
    title = fields.String()
    title_genitive = fields.String(dump_to='titleGenitive')
    title_prepositional = fields.String(dump_to='titlePrepositional')


class TransportSchema(Schema):
    main_city = fields.Nested(TransportMainCitySchema, dump_to='mainCity')
    secondary_city = fields.Nested(TransportMainCitySchema, dump_to='secondaryCity')
    cities = fields.Nested(TransportCitySchema, many=True)
    countries = fields.Nested(TransportCountrySchema, many=True)
