# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.utils.translation import get_language
from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from common.data_api.transport_page.transport_country import get_full_transport_data
from travel.rasp.morda_backend.morda_backend.transport.data_layer import make_transport_result
from travel.rasp.morda_backend.morda_backend.transport.serialization import TransportRequestSchema, TransportSchema


log = logging.getLogger(__name__)


@api_view(['GET'])
def get_transport(request, t_type_code):
    """
    https://st.yandex-team.ru/RASPFRONT-6606
    Контент для страницы транспорта
    Пример запроса: /ru/transport/bus/?country=RU
    """
    context, errors = TransportRequestSchema().load(request.GET)
    if 'country' not in context:
        return Response({'errors': 'Request without country param'}, status=status.HTTP_404_NOT_FOUND)

    full_data = get_full_transport_data()
    if t_type_code not in full_data or context['country'] not in full_data[t_type_code]:
        return Response(
            {'errors': 'No data for given transport type and country'}, status=status.HTTP_404_NOT_FOUND
        )

    result = make_transport_result(full_data, t_type_code, context['country'], get_language())

    return Response(TransportSchema().dump(result).data)
