# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.i18n import i18n_patterns
from django.conf.urls.static import static

from common.views.db_info import db_info

import travel.rasp.morda_backend.morda_backend.search.transfers.views
import travel.rasp.morda_backend.morda_backend.tariffs.bus.views
import travel.rasp.morda_backend.morda_backend.tariffs.suburban.views
import travel.rasp.morda_backend.morda_backend.views.altlinks
import travel.rasp.morda_backend.morda_backend.views.maintenance
import travel.rasp.morda_backend.morda_backend.views.countries
import travel.rasp.morda_backend.morda_backend.views.currencies
import travel.rasp.morda_backend.morda_backend.views.statictext

from travel.rasp.morda_backend.morda_backend.search.canonicals.views import canonicals
from travel.rasp.morda_backend.morda_backend.search.parse_context.views import parse_context
from travel.rasp.morda_backend.morda_backend.search.search.views import search
from travel.rasp.morda_backend.morda_backend.search.train_segment.views import train_segment
from travel.rasp.morda_backend.morda_backend.search.transfers.views import variants
from travel.rasp.morda_backend.morda_backend.search.pm_variants.views import pathfinder_maps_variants

from travel.rasp.morda_backend.morda_backend.station.views import (
    station, station_stops, station_quick, station_city_stations, station_popular_directions
)
from travel.rasp.morda_backend.morda_backend.article.views import articles, staticpage
from travel.rasp.morda_backend.morda_backend.tariffs.daemon import views as tariffs_daemon_views
from travel.rasp.morda_backend.morda_backend.tariffs.static import views as tariffs_static_views
from travel.rasp.morda_backend.morda_backend.thread.views import thread, thread_map
from travel.rasp.morda_backend.morda_backend.settlement.views import settlement as settlement_views
from travel.rasp.morda_backend.morda_backend.transport.views import get_transport


sync_urlpatterns = i18n_patterns(
    url(r'^settlement/(\d+)/stations/$', settlement_views.stations_by_settlement_id),
    url(r'^settlement/([\w-]+)/stations/$', settlement_views.stations_by_settlement_slug),
    url(r'^settlement/(\d+)/directions/$', settlement_views.directions),
    url(r'^settlement/$', settlement_views.get_settlement),
    url(r'^settlement/(\d+)/teasers/$', settlement_views.teasers),
    url(r'^settlement/(\d+)/search-sample-points/$', settlement_views.search_sample_points),
    url(r'^settlement/(\d+)/popular-directions/$', settlement_views.popular_directions),
    url(r'^settlement/(\d+)/train-popular-directions/$', settlement_views.train_popular_directions),
    url(r'^settlement/([\w-]+)/transport-popular-directions/$', settlement_views.transport_popular_directions),

    url(r'^transport/(bus|train|suburban|plane)/$', get_transport),

    url(r'^search/parse-context/$', parse_context),
    url(r'^search/search/$', search, name='search'),
    url(r'^search/train-segment/$', train_segment, name='train_segment'),
    url(r'^search/canonicals/$', canonicals),
    url(r'^search/transfers/$', variants),
    url(r'^search/pathfinder-maps-variants/$', pathfinder_maps_variants, name='pathfinder_maps_variants'),

    url(r'^segments/tariffs/$', tariffs_daemon_views.tariffs),
    url(r'^segments/tariffs/poll/$', tariffs_daemon_views.tariffs, {'poll': True}),
    url(r'^segments/min-tariffs/$', tariffs_daemon_views.min_dynamic_tariffs),
    url(r'^segments/bus-tariffs/$', travel.rasp.morda_backend.morda_backend.tariffs.bus.views.tariffs),

    url(r'^tariffs/plane/$', tariffs_daemon_views.tariffs_init),
    url(r'^tariffs/plane/poll/$', tariffs_daemon_views.tariffs_poll),
    url(r'^tariffs/static-tariffs/$', tariffs_static_views.static_tariffs),
    url(r'^tariffs/min-static-tariffs/$', tariffs_static_views.min_static_tariffs),
    url(r'^tariffs/suburban/$', travel.rasp.morda_backend.morda_backend.tariffs.suburban.views.suburban),

    url(r'^thread/$', thread),
    url(r'^thread/map/$', thread_map),

    url(r'^station/$', station),
    url(r'^station/quick/$', station_quick),
    url(r'^station/stops/$', station_stops),
    url(r'^station/city_stations/$', station_city_stations),
    url(r'^station/popular_directions/$', station_popular_directions),

    url(r'^articles/$', articles),
    url(r'^staticpage/$', staticpage),

    url(r'^statictext/disclaimers/$', travel.rasp.morda_backend.morda_backend.views.statictext.disclaimer),
    url(r'^currencies/$', travel.rasp.morda_backend.morda_backend.views.currencies.currencies),
    url(r'^countries/$', travel.rasp.morda_backend.morda_backend.views.countries.countries),
    url(r'^maintenance/$', travel.rasp.morda_backend.morda_backend.views.maintenance.get_conf),
)

sync_urlpatterns += [
    url(r'^altlinks/(\w+)/(.*)$', travel.rasp.morda_backend.morda_backend.views.altlinks.altlinks_path),
    url(r'^altlinks/?$', travel.rasp.morda_backend.morda_backend.views.altlinks.altlinks_get_params),

    url(r'^dev/dbinfo$', db_info),
    url('', include('common.views.version')),
]


urlpatterns = sync_urlpatterns


if settings.DEBUG:
    import debug_toolbar
    urlpatterns += [url(r'^__debug__/', include(debug_toolbar.urls))]
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
