# -*- coding: utf-8 -*-

from copy import copy

from django.conf import settings

from travel.rasp.morda_backend.morda_backend.data_layer.decorators import json_response
from url_mapper import map_url


def get_altlinks(from_, url):
    altlinks = {}
    for to, data in settings.RASP_ALTVERSIONS.items():
        if to != from_:
            href = map_url(from_, to, url)
            if href:
                altlink = copy(data['attrs'])
                altlink['href'] = href
                altlinks[to] = altlink

    return altlinks


@json_response
def altlinks_path(request, from_, url):
    return get_altlinks(from_, url)


@json_response
def altlinks_get_params(request):
    from_ = request.GET['from']  # key from RASP_ALTVERSIONS
    url = request.GET['url']
    return get_altlinks(from_, url)
