# -*- coding: utf-8 -*-

import logging

from django.conf import settings
from rest_framework.decorators import api_view
from rest_framework.response import Response

from common.models.geo import Country
from common.utils.i18n import CollateUnicode

log = logging.getLogger(__name__)


@api_view(['GET'])
def countries(request):
    national_version = request.GET.get('national_version')
    sng_country_ids = settings.SNG_COUNTRIES
    kubr_country_ids = [Country.RUSSIA_ID, Country.UKRAINE_ID, Country.BELARUS_ID, Country.KAZAKHSTAN_ID]

    countries = sorted(
        Country.objects.all(),
        key=lambda country: (
            0 if country.domain_zone == national_version else 1,
            kubr_country_ids.index(country.id) if country.id in kubr_country_ids else 1000,
            0 if country.id in sng_country_ids else 1,
            CollateUnicode(country.L_title())
        )
    )

    return Response({'countries': [
        {
            'id': country.id,
            'title': country.L_title(),
            'code2': country.code,
            'code3': country.code3,
            'geoId': country._geo_id,
        } for country in countries]
    })
