# -*- coding: utf-8 -*-

from common.models.currency import Currency
from common.utils.currency_converter import NATIONAL_CURRENCY_RATES_GEOID, CURRENCY_RATES_GEOID
from travel.rasp.morda_backend.morda_backend.data_layer.decorators import json_response


@json_response
def currencies(request):
    national_version = request.GET.get('national_version')
    geo_id = NATIONAL_CURRENCY_RATES_GEOID.get(national_version, CURRENCY_RATES_GEOID)
    base_currency = request.GET.get('base') or 'RUB'

    currencies = list(Currency.get_ordered_queryset(national_version))
    __, rates = Currency.fetch_rates(currencies, geo_id, base_currency)

    return {
        'currencies': [{
            'code': currency.iso_code,
            'title': currency.L_name(),
            'rate': rates.get(currency.iso_code, rates.get(currency.code))
        } for currency in currencies]
    }
