PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/ipython
    contrib/python/unicodecsv
    contrib/python/django-debug-toolbar

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/library/python/entrypoint
    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/mapping
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
    travel/rasp/library/python/tracing
    travel/rasp/library/python/url_mapper

    travel/library/python/dev/pydevd_inject
)

PY_SRCS(
    app.py
    docker/local_settings.py
    gunicorn_conf.py
    settings.py
    tests_settings.py
    wsgi.py

    morda_backend/__init__.py
    morda_backend/app.py

    morda_backend/article/data_layer.py
    morda_backend/article/serialization.py
    morda_backend/article/views.py

    morda_backend/debug_urls.py

    morda_backend/data_layer/decorators.py
    morda_backend/data_layer/error.py
    morda_backend/data_layer/popular_directions.py
    morda_backend/data_layer/segments_helpers.py

    morda_backend/middleware/set_locale.py
    morda_backend/middleware/set_exps_flags.py

    morda_backend/search/canonicals/serialization.py
    morda_backend/search/canonicals/views.py
    morda_backend/search/merge_trains.py
    morda_backend/search/parse_context/geosearch_serialization.py
    morda_backend/search/parse_context/geosearch_wrapper.py
    morda_backend/search/parse_context/point.py
    morda_backend/search/parse_context/serialization.py
    morda_backend/search/parse_context/views.py
    morda_backend/search/pm_variants/serialization.py
    morda_backend/search/pm_variants/service.py
    morda_backend/search/pm_variants/views.py
    morda_backend/search/search/data_layer/all_types_search.py
    morda_backend/search/search/data_layer/avia_segments.py
    morda_backend/search/search/data_layer/backend.py
    morda_backend/search/search/data_layer/banner.py
    morda_backend/search/search/data_layer/baris_search.py
    morda_backend/search/search/data_layer/base_search.py
    morda_backend/search/search/data_layer/rasp_db_search.py
    morda_backend/search/search/data_layer/teasers.py
    morda_backend/search/search/serialization/archival_data_serialization.py
    morda_backend/search/search/serialization/avia_response_serialization.py
    morda_backend/search/search/serialization/response_serialization.py
    morda_backend/search/search/serialization/request_serialization.py
    morda_backend/search/search/views.py
    morda_backend/search/segment.py
    morda_backend/search/train_segment/data_layer.py
    morda_backend/search/train_segment/serialization.py
    morda_backend/search/train_segment/views.py
    morda_backend/search/transfers/serialization.py
    morda_backend/search/transfers/service.py
    morda_backend/search/transfers/views.py

    morda_backend/serialization/fields.py
    morda_backend/serialization/schema_bases.py
    morda_backend/serialization/segment.py
    morda_backend/serialization/segment_station.py
    morda_backend/serialization/segment_suburban_facilities.py
    morda_backend/serialization/segment_transport.py
    morda_backend/serialization/teasers.py

    morda_backend/settlement/data_layer/popular_directions.py
    morda_backend/settlement/data_layer/request.py
    morda_backend/settlement/data_layer/search_sample_points.py
    morda_backend/settlement/data_layer/settlement.py
    morda_backend/settlement/data_layer/stations_by_settlement.py
    morda_backend/settlement/data_layer/train_popular_directions.py
    morda_backend/settlement/serialization/popular_directions.py
    morda_backend/settlement/serialization/search_sample_point.py
    morda_backend/settlement/serialization/settlement.py
    morda_backend/settlement/serialization/station.py
    morda_backend/settlement/serialization/station_helpers.py
    morda_backend/settlement/serialization/train_popular_directions.py
    morda_backend/settlement/views/settlement.py

    morda_backend/station/data_layer/base_station.py
    morda_backend/station/data_layer/base_station_thread.py
    morda_backend/station/data_layer/bus.py
    morda_backend/station/data_layer/city_stations.py
    morda_backend/station/data_layer/page_context.py
    morda_backend/station/data_layer/page_type.py
    morda_backend/station/data_layer/plane.py
    morda_backend/station/data_layer/popular_directions.py
    morda_backend/station/data_layer/station.py
    morda_backend/station/data_layer/suburban.py
    morda_backend/station/data_layer/tablo.py
    morda_backend/station/data_layer/train.py
    morda_backend/station/request_serialization.py
    morda_backend/station/response_serialization.py
    morda_backend/station/views.py

    morda_backend/tariffs/bus/price_logging.py
    morda_backend/tariffs/bus/serialization.py
    morda_backend/tariffs/bus/service.py
    morda_backend/tariffs/bus/views.py
    morda_backend/tariffs/daemon/serialization.py
    morda_backend/tariffs/daemon/service.py
    morda_backend/tariffs/daemon/views.py
    morda_backend/tariffs/serialization.py
    morda_backend/tariffs/static/partners/__init__.py
    morda_backend/tariffs/static/partners/allticketsfor_me.py
    morda_backend/tariffs/static/partners/avperm.py
    morda_backend/tariffs/static/partners/donavto.py
    morda_backend/tariffs/static/partners/e_traffic.py
    morda_backend/tariffs/static/partners/helpers.py
    morda_backend/tariffs/static/partners/infobus.py
    morda_backend/tariffs/static/partners/kvc_tula.py
    morda_backend/tariffs/static/partners/mrtrans.py
    morda_backend/tariffs/static/partners/neoplan_trans_tur.py
    morda_backend/tariffs/static/partners/pavlodar.py
    morda_backend/tariffs/static/partners/takebus.py
    morda_backend/tariffs/static/partners/udmbus.py
    morda_backend/tariffs/static/partners/unistation.py
    morda_backend/tariffs/static/partners/unitiki.py
    morda_backend/tariffs/static/partners/utisauto.py
    morda_backend/tariffs/static/serialization.py
    morda_backend/tariffs/static/service.py
    morda_backend/tariffs/static/views.py
    morda_backend/tariffs/suburban/serialization.py
    morda_backend/tariffs/suburban/service.py
    morda_backend/tariffs/suburban/views.py
    morda_backend/tariffs/train/base/models.py
    morda_backend/tariffs/train/base/utils.py

    morda_backend/thread/data_layer.py
    morda_backend/thread/serialization.py
    morda_backend/thread/views.py

    morda_backend/transport/data_layer.py
    morda_backend/transport/serialization.py
    morda_backend/transport/views.py

    morda_backend/urls.py

    morda_backend/views/altlinks.py
    morda_backend/views/countries.py
    morda_backend/views/currencies.py
    morda_backend/views/maintenance.py
    morda_backend/views/statictext.py
)

RESOURCE_FILES(
    morda_backend/xgettext/keyset.json
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
