import argparse
import os

from travel.rasp.mysql_dumper.lib.dumper_runner import run_dump, TYPES_TO_DUMP


def __main__(args):
    run_dump(
        host=args.host,
        user=args.user,
        password=os.environ['DB_PASSWORD'],
        db=args.db,
        precache_path=args.precache,
        file_by_type={
            name: getattr(args, name) for name in TYPES_TO_DUMP
        }
    )


def parse_args():
    parser = argparse.ArgumentParser()

    group = parser.add_argument_group('connection')
    group.add_argument('--host', required=True)
    group.add_argument('--user', required=True)
    group.add_argument('--db', required=True)

    parser.add_argument('--precache', required=True)

    for name in TYPES_TO_DUMP:
        parser.add_argument('--{}'.format(name), default=None)
        parser.add_argument('--{}_in_file'.format(name), default=100000, type=int)

    return parser.parse_args()


if __name__ == '__main__':
    __main__(parse_args())
