import argparse
import os

from travel.rasp.mysql_dumper.lib.normalizer import run_normalize


def main(args):
    run_normalize(
        host=args.host,
        user=args.user,
        password=os.environ['DB_PASS'],
        db=args.db,
        directory=args.directory,
    )


def parse_args():
    parser = argparse.ArgumentParser()

    group = parser.add_argument_group('connection')
    group.add_argument('--host', required=True)
    group.add_argument('--user', required=True)
    group.add_argument('--db', required=True)

    parser.add_argument('--directory', required=True)
    return parser.parse_args()


if __name__ == '__main__':
    main(parse_args())
