# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals


class Factory(object):
    def __init__(self, constructing_object, *args):
        self.constructing_object = constructing_object
        for arg in args:
            if isinstance(arg, Factory.set_field):
                setattr(self.constructing_object, arg.name, arg.value)
            elif isinstance(arg, Factory.add_to):
                item = getattr(self.constructing_object, arg.name).add()
                Factory(item, *arg.args)
            elif isinstance(arg, Factory.extend):
                getattr(self.constructing_object, arg.name).extend(arg.args)
            elif isinstance(arg, Factory.set_field_attr):
                Factory(getattr(self.constructing_object, arg.name), *arg.args)
            elif isinstance(arg, Factory.call_method):
                getattr(self.constructing_object, arg.name)(*arg.args, **arg.kwargs)
            else:
                raise ValueError(
                    "Incorrect argument: "
                    "expected instance of Factory subclasses "
                    "types but {} founded.".format(arg)
                )

    class set_field(object):
        def __init__(self, name, value):
            self.name = name
            self.value = value

    class add_to(object):
        def __init__(self, name, *args):
            self.name = name
            self.args = args

    class extend(object):
        def __init__(self, name, *args):
            self.name = name
            self.args = args

    class set_field_attr(object):
        def __init__(self, name, *args):
            self.name = name
            self.args = args

    class call_method(object):
        def __init__(self, name, *args, **kwargs):
            self.name = name
            self.args = args
            self.kwargs = kwargs

    def get(self):
        return self.constructing_object
