# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from pytest import mark

from travel.rasp.mysql_dumper.lib.dumpers import _convert_year_days


@mark.parametrize('days, expected', [
    (
        '0100001010000101000010100001010'
        '0001010000101000010100001010000'
        '0001010000101000000000000000000'
        '0000000000000000000000000000000'
        '0000001010000101000010100001010'
        '0001010000101000010100001010000'
        '0101000010100001010000101000010'
        '1000010100001010000101000010100'
        '0010100001010000101000010100000'
        '1010000101000010100001010000101'
        '0000101000010100001010000101000'
        '0010100001010000101000010100001',

        [
            558007562,
            169093200,
            169082880,
            0,
            21136650,
            169093200,
            676372802,
            1116015124,
            338186400,
            1352745605,
            84546600,
            338186401
        ]
    ),
    (
        '1111101111110111111011111101111'
        '1101111110111111011111101111000'
        '1101111110111111010000000000000'
        '0000000000000000000000000000000'
        '0000000111110111111011111101111'
        '1101111110111111011111101111110'
        '0111111011111101111110111111011'
        '1111011111101111110111111011111'
        '1011111101111110111111011111100'
        '1111110111111011111101111110111'
        '1110111111011111101111110111110'
        '1011111101111110111111011111101',
        [
            2113665007,
            1876934520,
            1876926464,
            0,
            16513007,
            1876934526,
            1065287163,
            2079846367,
            1606385404,
            2130574327,
            2012209086,
            1606385405
        ]
    )
])
def test_convert_years(days, expected):
    assert _convert_year_days(days) == expected
