#include "thegraph.h"
#include "tariff.h"

using namespace Pathfinder;

std::istream& file_open(std::ifstream& fin, const char* name)
{
    fin.open(name);
    return fin;
}

int main(int argc, char * argv[])
{
    std::string place("/home/kateov/work/rasp/rasp/www/db/scripts/data/pathfinder/rasp_kateov");
    //std::string place("C:/rasp/rasp_kateov");
	std::string tariffLog = "dump";
	//const std::string tariffLog = place + "/dump";
	std::string tariffOut = "tariff.out";
	if (argc > 1)
		place = argv[1];
	if (argc > 2)
		tariffLog = argv[2];
	if (argc > 3)
		tariffOut = argv[3];
	printf("%d %s\n", argc, place.c_str());

    TheGraph theGraph;

	const std::string currencyRatesFile = place + "/currency-rates.map";
	std::ifstream logFin1;
	std::istream& logFin = (tariffLog == "-c") ? std::cin : file_open(logFin1, tariffLog.c_str());
	
	DumpSeatPriceLogParser dumpSeatPriceLogParser;
	dumpSeatPriceLogParser.LoadCurrencyRates(currencyRatesFile.c_str());
	const size_t tariffLogRes = dumpSeatPriceLogParser.LoadLogWithoutGraph("log.txt", logFin, theGraph.SG);
	const size_t tariffLogOutRes = dumpSeatPriceLogParser.SaveLogWithoutGraph("log.txt", tariffOut.c_str(), theGraph.SG);

	return 0;
}

