#include "get.h"
#include "thegraph.h"
#include "timer.h"
#include <iostream>
//#define GOOGLE_PROF
#ifdef GOOGLE_PROF
#include <google/profiler.h>
#endif

using namespace Pathfinder;

// настройки (обычно либо все включено, либо все выключено):

// выводить кратко
#define BRIEF
// выводить только время
#define TIME_ONLY

int main(int argc, char * argv[])
{
    // где лежат данные для поиска
    //std::string place("/Users/kateov/work/rasp");
    std::string place("/home/kateov/workspace/admin/www/db/scripts/data/pathfinder/main1_rasp");
    if (argc > 1)
        place = argv[1];
    printf("%d %s\n", argc, place.c_str());

    const std::string date ("");

    // запросы чтоб обработать
    // поток запросов
    // разбор ошибок
    const std::string queries("/home/kateov/log/targetpathfinder.log.get");
    //const std::string queries("/home/kateov/log/wiz_req_new.txt");
    //const std::string queries("C:/rasp/targetpathfinder.log.get");

    const std::string dump_seat_price_files(place + "/dump");

    // названия нужных мне файлов
    const std::string thegraphTail("/thegraph");
    const std::string townTail("/townOrig-name.map");
    const std::string stationTail("/station-table.map");

    // строим пути
    const std::string tableFile(place + date + thegraphTail);
    const std::string townFile(place + date + townTail);
    const std::string stationFile(place + date + stationTail);

    // завели таймер и стартовали
    Timer timer;
    timer.start();

    // загружаем данные, результат пишем в graphRes
    // сюда загрузим данные, там же будет работать поиск
    TheGraph theGraph;
    const std::string timeZoneFile = place + "/time-zone.map";
    const int tzRes = theGraph.SG.st.timeZoneStorage.Load(timeZoneFile.c_str());

    const int towns = theGraph.SG.st.loadTowns(townFile.c_str());
    const int stations = theGraph.SG.st.loadStations(stationFile.c_str());

    const std::string stationGeoFile = place + "/stationOrig-geo.map";
    const int geoRes = theGraph.SG.st.loadGeo(stationGeoFile.c_str());

    const int graphRes = theGraph.SG.load(LOG_FILE_NAME, tableFile.c_str(), Transport::ALL);

    const std::string stationTeleportFile = place + "/station_teleport.map";
    const int teleportRes = theGraph.SG.st.loadTime2Center(stationTeleportFile.c_str());

    const std::string stationIntervalFile = place + "/interval-threads.map";
    const int intervalRes = theGraph.SG.loadIntervalThreadsInfo(LOG_FILE_NAME, stationIntervalFile.c_str());
    printf("loaded tz=%d teleports=%d geo=%d interval=%d\n", tzRes, teleportRes, geoRes, intervalRes);

    theGraph.SG.createAllStructures(LOG_FILE_NAME);

#ifdef PRICES_ON
    const std::string aeroextariffFile(place + "/aeroextariff.map");
    const std::string threadtariffFile(place + "/threadtariff.map");
    std::ifstream dumpFin((place + "/../dump").c_str());
    printf("%d %s\n", argc, (place + "/../dump").c_str());
    const std::string currencyRatesFile = place + "/currency-rates.map";
    theGraph.loadTariffs(LOG_FILE_NAME, aeroextariffFile.c_str(), threadtariffFile.c_str(), currencyRatesFile.c_str(), dumpFin/*std::cin*/);
#endif

    //theGraph.SG.st.saveCostations(LOG_FILE_NAME);
    theGraph.pathStorageSetStationNumber();
    // измерили скорость загрзки
    timer.stop();
    // и напечатали
#ifdef TIMING
    fprintf(stdout, "graph (%d): %ld, towns=%d, stations=%d\n", graphRes, static_cast<long>(timer.getTime()), towns, stations);
#endif

    // печатаем и обрабатываем запросы
    std::fstream fque(queries.c_str(), std::ios::in);
    std::string query;
    int count = 0, countFaster30 = 0;
    int sumInitTime = 0, sumMainTime = 0, sumFirstStepTime = 0;;
    int pricedReqNumber = 0, pricedAnsNumber = 0, ansNumber = 0;

#ifdef GOOGLE_PROF
    ProfilerStart("SearchMain");
#endif
    while(std::getline(fque, query))
    {
        // если встречаем пустой запрос, то все заканчиваем
        if (query.size() == 0)
            break;

        // печатаем запрос
#ifndef TIME_ONLY
        fprintf(stdout,"\n{%d} %s\n", count, query.c_str());
#endif

        Pathfinder::Get get;

        Pathfinder::Condition condition;
#ifdef FOR_WIZARD
        char cfrom, cto;
			int sfrom, sto;
			int iwizreq;
			sscanf(query.c_str(), "%*s %d %c%d %c%d", &iwizreq, &cfrom, &sfrom, &cto, &sto);
			int minute = 0, hour = 0, year = 2016, month = 1, dayOfMonth = 26;
            Pathfinder::Time _startTime = (Pathfinder::Time)(minute + hour * MINUTES_IN_HOUR + static_cast<int>(Pathfinder::Dates::toDay(year, month - 1, dayOfMonth - 1)) * MINUTES_IN_DAY);

			condition = Pathfinder::Condition(_startTime, 1440, 120, 1380, Pathfinder::Transport::ALL, false, false, false, false, true, false, 2);

			condition._fromStation = theGraph.SG.st.getStationByOrig(sfrom);
			condition._toStation = theGraph.SG.st.getStationByOrig(sto);
            printf("%d ", iwizreq);
#else
        // загружаем (т.е. разбираем запрос)
        get.load(query);
        theGraph.pathStorageStartWork(get._mode, get._timeLimit);
        // формируем условия поиска (из запроса)
        condition = Pathfinder::Condition(get._startTime, get._boarding, get._minDelay, get._maxDelay
                , get._transport, get._iLoveSport
                , get._canChangeInStartTown, get._canChangeInFinishTown, get._canChangeInAnyTown
                , true, get._usePrice, MAX_CHANGES);
        // переводим глобальные идентификаторы в локальные
        condition._fromStation = theGraph.SG.st.getStationByOrig(get._fromID);
        condition._toStation = theGraph.SG.st.getStationByOrig(get._toID);
#endif

        if (condition._toStation)
            condition._toStationIsTown = theGraph.SG.st.isTown(condition._toStation);
        else
            condition._toStationIsTown = 0;
        theGraph.SG.st.allStationsFrom_startOnly(condition._fromStation, condition._from);
        theGraph.SG.st.allStationsFrom_finishOnly(condition._toStation, condition._to);
        theGraph.SG.st.addTownsWith(condition._from, condition._endingTowns);
        theGraph.SG.st.addTownsWith(condition._to, condition._endingTowns);

        if (!condition._from.empty() && !condition._to.empty() && theGraph.SG.st.fromOneTown(condition._from[0], condition._to[0]))
        {
            condition._canChangeInStartTown = true;
            condition._canChangeInFinishTown = true;
            condition._canTeleport = false;
        }

#ifdef DEBUG_ROUTE
        if (!get._debugStationIDs.empty() || !get._debugRoutes.empty())
		{
			std::fstream out(DEBUG_LOG_FILE, std::ios::out | std::ios::app);
			out << "---------------------------------------------------------------" << std::endl;
			out << "request = " << query << std::endl;
            theGraph.setDebugRoute(get._debugStationIDs, get._debugRoutes);
		}
#endif

        // иногда хочется замерить время точнее, для чего запускаем поиск несколько раз (times)
        timer.start();
        // поиск
        std::string res = theGraph.search1(LOG_FILE_NAME, condition);
        timer.stop();
        int initTime = (int)timer.getTime();
        timer.start();
        if (res.empty())
            res = theGraph.search2(LOG_FILE_NAME, condition);
        timer.stop();
        int firstStepTime = (int)timer.getTime();
        timer.start();
#ifdef GOOGLE_PROF
        ProfilerEnable();
#endif
        if (res.empty())
            res = theGraph.search3(LOG_FILE_NAME, condition);
#ifdef GOOGLE_PROF
        ProfilerDisable();
#endif
        timer.stop();
        sumInitTime += initTime;
        sumFirstStepTime += firstStepTime;
        sumMainTime += (int)timer.getTime();
        int workTime = initTime + firstStepTime + (int)timer.getTime();
        int priced = theGraph.getResultPricedNumber();
        if (priced > 0)
        {
            pricedReqNumber++;
            pricedAnsNumber+=priced;
            ansNumber+=theGraph.getResultNumber();
        }
#ifdef FOR_WIZARD
        if (workTime <= 40000 && theGraph.getResultNumber()>0)
#else
        if (workTime <= 40000)
#endif
            countFaster30++;

        // фиксируем время
        timer.stop();

        fprintf(stdout, "%d", count);
        fprintf(stdout, "\tsize:%d", static_cast<int>(theGraph.getResultNumber()));
        fprintf(stdout, "\t%s ", res.c_str());
//        fprintf(stdout, "\tfront-all:%d\tI:%d\tF:%d\tM:%d\trps:%f", theGraph.getAllPathNumber(), initTime, firstStepTime, (int)timer.getTime(), 1000000.0/workTime);
        int bcn = theGraph.getBestChangesNumber();
        fprintf(stdout, "\tch=%d(%d+%d)", theGraph.getBestChanges(), bcn, static_cast<int>(theGraph.resultNumber())-bcn);
        fprintf(stdout, "\ttime=%d\tpr=%f\tdc=%d", theGraph.getBestTime(), theGraph.getBestPrice(), theGraph.getBestDiscomfort());
        if (condition._fromStation && condition._toStation)
            fprintf(stdout, "\t%s->%s\t%s", condition._fromStation->name.c_str(), condition._toStation->name.c_str(), get._dateOfStart.c_str());
        fprintf(stdout, "\n");
//        fprintf(stdout, "\n%s", theGraph.resultToDebugString().c_str());
///        fprintf(stdout, "\n\n\nxml:\n%s", theGraph.resultToXML().c_str());
//        theGraph.searchDebugOutput(stdout);
        theGraph.pathStorageClear();
        count++;
    }
#ifdef GOOGLE_PROF
    ProfilerStop();
#endif
    fprintf(stdout, "sumTime=%d\t(sumInitTime=%d + sumFirstStepTime=%d + sumMainTime=%d)\tless_30_ms=%d\tavgTime=%f\tavgRPS=%f\n"
            , sumInitTime+sumFirstStepTime+sumMainTime, sumInitTime, sumFirstStepTime, sumMainTime, countFaster30
            , (float)((sumInitTime+sumFirstStepTime+sumMainTime)/(float)count), (float)(1000000.0 / (float)((sumInitTime+sumFirstStepTime+sumMainTime)/(float)count)));
    fprintf(stdout, "reqs=%d\tpricedReqs=%d\tPercentOfPricesAnsInPricedReqs=%.3f\n", count, pricedReqNumber, (1.0*pricedAnsNumber)/ansNumber);
    return 0;
}

