#if !defined(BASE_H)
#define BASE_H

// взял из аркадии

// определяем платформу
#if defined (_WIN64)
#   define _win64_
#elif defined (__WIN32__) || defined (_WIN32) // _WIN32 is also defined by the 64-bit compiler for backward compatibility
#   ifndef _win32_
#   define _win32_
#   endif
#else
#   define _unix_
#   if defined (__sun__) || defined (sun) || defined(sparc) || defined (__sparc)
#       define _sun_
#   endif
#   if defined (__hpux__)
#       define _hpux_
#   endif
#   if defined (__linux__)
#       define _linux_
#   endif
#   if defined (__FreeBSD__)
#       define _freebsd_
#   endif
#   if defined (__CYGWIN__)
#       define _cygwin_
#   endif
#   if defined (__APPLE__)
#       define _darwin_
#   endif
#   if defined (__ARC_OS__)
#       define _arc_os_
#   endif
#endif

// основные целочисленные типы
#if (defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)) || defined(_linux_) || defined(_cygwin_) || (defined(__FreeBSD__) && __FreeBSD__ > 4)

#   ifndef __STDC_CONSTANT_MACROS
#       define __STDC_CONSTANT_MACROS
#   endif
#   ifndef __STDC_FORMAT_MACROS
#       define __STDC_FORMAT_MACROS
#   endif
#   include <inttypes.h>
    typedef int8_t i8;
    typedef int16_t i16;
    typedef int32_t i32;
    typedef int64_t i64;
    typedef uint8_t ui8;
    typedef uint16_t ui16;
    typedef uint32_t ui32;
    typedef uint64_t ui64;
#   define LL(number)   INT64_C(number)
#   define ULL(number)  UINT64_C(number)

#else

#   include <climits>

    typedef signed char i8;
    typedef unsigned char ui8;

#if (INT_MAX == 0x7FFF)
    typedef int i16;
    typedef unsigned int ui16;
#   define  PRId32 "d"
#   define  PRIi32 "i"
#   define  PRIo32 "o"
#   define  PRIu32 "u"
#   define  PRIx32 "x"
#   define  PRIX32 "X"
#   define  SCNd32 "d"
#   define  SCNi32 "i"
#   define  SCNo32 "o"
#   define  SCNu32 "u"
#   define  SCNx32 "x"
#elif (SHRT_MAX == 0x7FFF)
    typedef short i16;
    typedef unsigned short ui16;
#   define  PRId16 "hd"
#   define  PRIi16 "hi"
#   define  PRIo16 "ho"
#   define  PRIu16 "hu"
#   define  PRIx16 "hx"
#   define  PRIX16 "hX"
#   define  SCNd16 "hd"
#   define  SCNi16 "hi"
#   define  SCNo16 "ho"
#   define  SCNu16 "hu"
#   define  SCNx16 "hx"
#else
#   error i16 does not exist
#endif

#if (INT_MAX == 0x7FFFFFFFL)
    typedef int i32;
    typedef unsigned int ui32;
#   define  PRId32 "d"
#   define  PRIi32 "i"
#   define  PRIo32 "o"
#   define  PRIu32 "u"
#   define  PRIx32 "x"
#   define  PRIX32 "X"
#   define  SCNd32 "d"
#   define  SCNi32 "i"
#   define  SCNo32 "o"
#   define  SCNu32 "u"
#   define  SCNx32 "x"
#elif (LONG_MAX == 0x7FFFFFFFL)
    typedef long i32;
    typedef unsigned long ui32;
#   define  PRId32 "ld"
#   define  PRIi32 "li"
#   define  PRIo32 "lo"
#   define  PRIu32 "lu"
#   define  PRIx32 "lx"
#   define  PRIX32 "lX"
#   define  SCNd32 "ld"
#   define  SCNi32 "li"
#   define  SCNo32 "lo"
#   define  SCNu32 "lu"
#   define  SCNx32 "lx"
#else
#   error i32 does not exist
#endif

// names for i64, ui64
// hyper;long long;LONGLONG;LARGE_INTEGER;__int64;int64_t;int64
// unsigned hyper;unsigned long long;DWORDLONG;ULONGLONG;ULARGE_INTEGER;
// unsigned __int64;u_int64_t;uint64_t;uint64;u_int64

#if (LONG_MAX > 0x7FFFFFFFL)
#   define COMPILER_SUPPORTS_64
    typedef long i64;
    typedef unsigned long ui64;
#   define  LL(number)  number##l
#   define  ULL(number) number##ul
#   define  PRId64 "ld"
#   define  PRIi64 "li"
#   define  PRIo64 "lo"
#   define  PRIu64 "lu"
#   define  PRIx64 "lx"
#   define  PRIX64 "lX"
#   define  SCNd64 "ld"
#   define  SCNi64 "li"
#   define  SCNo64 "lo"
#   define  SCNu64 "lu"
#   define  SCNx64 "lx"
#elif defined (__GNUC__)
#   define COMPILER_SUPPORTS_64
    typedef long long i64;
    typedef unsigned long long ui64;
#   define  LL(number)  number##ll
#   define  ULL(number) number##ull
#   define  PRId64 "lld"
#   define  PRIi64 "lli"
#   define  PRIo64 "llo"
#   define  PRIu64 "llu"
#   define  PRIx64 "llx"
#   define  PRIX64 "llX"
#   define  SCNd64 "lld"
#   define  SCNi64 "lli"
#   define  SCNo64 "llo"
#   define  SCNu64 "llu"
#   define  SCNx64 "llx"
#elif defined _MSC_VER
#   define COMPILER_SUPPORTS_64
    typedef __int64 i64;
    typedef unsigned __int64 ui64;
#   define  LL(number)  number##i64
#   define  ULL(number) number##ui64
#   define  PRId64 "I64d"
#   define  PRIi64 "I64i"
#   define  PRIo64 "I64o"
#   define  PRIu64 "I64u"
#   define  PRIx64 "I64x"
#   define  PRIX64 "I64X"
#   define  SCNd64 "I64d"
#   define  SCNi64 "I64i"
#   define  SCNo64 "I64o"
#   define  SCNu64 "I64u"
#   define  SCNx64 "I64x"
#endif

#endif

#endif

