#include "stationtown.h"
#include "stationgraph.h"
#include "curve.h"

namespace Geom
{
    int Curve::setBestWithMap(const CurveMapInfo& map)
    {
        size_t n = points.size();
        bestPoint.resize(n, 0);
        int res = 0;
        if (coef > map.coef()) //только более маленькая, подробная карта может повлиять на нас
        {
            if (map.intersectWith(CurveMapInfo("", lb, rt))) //если у кривой есть шанс пересечься с картой map
            {
                for (size_t i = 0; i < n; i++)
                    if (map.inThisMap(points[i]))
                    {
                        bestPoint[i]++;
                        if (bestPoint[i] > res)
                            res = bestPoint[i];
                    }
            }
        }
        return res;
    }


    size_t CurveMap::setStationsOnCurves(std::ostream& out, std::ostream& log, ::Pathfinder::StationInfos& si
            , const ::Pathfinder::Transport::Type& trFilter, const double eps, const double coefNeig, const bool paint, const bool do_log)
    {
        size_t res = 0;
        for (::Pathfinder::StationInfos::iterator it = si.begin(); it != si.end(); ++it)
        {
            if (it->transports & trFilter)
            if (!it->location.IsZero())
            {
                Geom::NearCurves nearCurves;
                std::vector<const Geom::Curve*> neigCurves;
                for (size_t i = 0; i < it->nearestStations.size(); i++)
                    if (it->nearestStations[i]->curve)
                        neigCurves.push_back(it->nearestStations[i]->curve);
                getNearCurves(neigCurves, it->location, eps, coefNeig, nearCurves);
                std::sort(nearCurves.begin(), nearCurves.end());
                int j = 0;
                for (NearCurves::iterator curve = nearCurves.begin(); curve != nearCurves.end(); ++curve, j++)
                {
                    if (paint && curve->dist < nearCurves[0].dist*1.5)
                    {
                        out << "[POLYLINE]\nType=0x06\nData0=("
                        << it->location.x << "," << it->location.y
                        << "),("
                        << curve->point.x << "," << curve->point.y
                        << ")"
                        << "\nLabel=" << it->name << "--" << j << "--"
                        << curve->newP << " dist=" << curve->dist
                        << " ending=" << curve->endingP << " eps=" << eps
                        << " parL=" << curve->parentLine;
                        for (size_t i = 0; i < neigCurves.size(); i++)
                            out << " nc" << i << ":" << neigCurves[i]->id;
                        out	<< "\n[END]\n" << std::endl;
                    }
                }
                if (!nearCurves.empty())
                {
                    int i=0;
                    double coef = 0;
                    double dist = nearCurves[0].dist;
                    for (i=0; i < nearCurves.size(); i++)
                        dist = std::min(dist, nearCurves[i].dist);
                    if (dist != nearCurves[0].dist)
                        for (i=0; i < nearCurves.size() && (nearCurves[i].curve->coef <= coef
                                                            || (nearCurves[i].endingP && nearCurves[i].dist >= eps*0.02 && nearCurves[i].curve->neigCurves.empty())); i++)
                            coef = std::max(coef, nearCurves[i].curve->coef);
                    else
                        i = 0;
                    if (i < nearCurves.size())
                    {
                        if (do_log)
                            log << it->id << "\t" << it->name << "\tstation_move_to_curve\tfrom\t" << it->location.x << "," << it->location.y
                            << "\tto\t" << nearCurves[i].point.x << "," << nearCurves[i].point.y
                            << "\tdist=" << Geom::SphereLen(it->location, nearCurves[i].point) << "\tcurvecoef=" << nearCurves[i].curve->coef
                            << "\tnp=" << nearCurves.size()  << "\ti=" << i << std::endl;
                        it->location = nearCurves[i].point;
                        it->curve = nearCurves[i].curve;
                        res++;
                    }
                    else
                    if (do_log)
                        log << std::endl << "ending_point\t" << it->id << "\t" << it->name << "\t" << it->location.x << "," << it->location.y
                        << " endingP=" << nearCurves[0].endingP << " dist=" << nearCurves[0].dist << " neigCurves=" << nearCurves[0].curve->neigCurves.size() << std::endl;
                }
                else if (do_log)
                    log << "no_curves" << it->id << "\t" << it->name << "\t" << it->transports << " ->\t" << it->location.x << ", " << it->location.y << std::endl;
            }
        }
        return res;
    }

    int CurveMap::setStationsOnCurves_correction(std::istream& in, std::ostream& out, std::ostream& log, ::Pathfinder::StationTown& st)
    {
        ::Pathfinder::Station id;
        double x, y;
        double e;
        int res = 0;
        while (in >> id >> x >> y >> e)
        {
            ::Pathfinder::Station s = st.getStationInnerID(id);
            if (s == -1)
            {
                log << "Error!!! no such station " << id << std::endl;
                continue;
            }
            ::Pathfinder::StationInfos::iterator it = st.stationInfos.begin() + s;
            if (x != 0.0 || y != 0.0)
            {
                it->location = Point2d(x, y);
                it->curve = 0;
            }
            else
            {
                it->location = it->oldLocation;
                it->curve = 0;
            }
            if (it->location.IsZero())
                continue;

            //Ставим точку на линию без учета соседей с нужным eps = e
            Geom::NearCurves nearCurves;
            std::vector<const Geom::Curve*> neigCurves;
            getNearCurves(neigCurves, it->location, e, 1, nearCurves);
            std::sort(nearCurves.begin(), nearCurves.end(), lessNearCurve);
            if (!nearCurves.empty())
            {
                bool paint = false;
                if (paint)
                {
                    out << "[POLYLINE]\nType=0x06\nData0=("
                    << it->location.x << "," << it->location.y
                    << "),("
                    << nearCurves[0].point.x << "," << nearCurves[0].point.y
                    << ")"
                    << "\nLabel=!correct! " << it->name << "--" << nearCurves[0].newP << " dist=" << nearCurves[0].dist << " parL=" << nearCurves[0].parentLine;
                    out	<< "\n[END]\n" << std::endl;
                }
                it->location = nearCurves[0].point;
                it->curve = nearCurves[0].curve;
                log << id << "\t" << it->name << "\tset_correction ->\t" << it->location << "\t dist = " << nearCurves[0].dist << "\t np = " << nearCurves.size() << std::endl;
                res++;
            }
            else
                log << id << "\t" << it->name << "\tset_correction ->\t" << it->location << std::endl;
        }
        return res;
    }

    size_t CurveMap::createPoint2StationMap(::Pathfinder::StationInfos& si, const ::Pathfinder::Transport::Type& trFilter)
    {
        size_t res = 0;
        for (::Pathfinder::StationInfos::iterator it = si.begin(); it != si.end(); ++it)
        {
            if (!it->location.IsZero() && (it->transports & trFilter))
                point2StationMap[it->location] = &(*it);
        }
        return res;
    }

    bool CurveMap::addNode(const Point2d& p1, const Point2d& p2, const double d
            , const Node* parent, const Curve* curve, int n, Point2d p
            , Nodes& nodes, SetNodes& setNodes, Queue& queue
            , const double maxrast, const double eps)
    {
        if ((p-p2).Len() > 3*d || (p-p1).Len() > 3*d)
            return false;

        Node node(curve, n, p);
        node.p1 = p1;
        bool comeToStation = false;

        Point2StationMap::iterator st = point2StationMap.find(p);
        if (st != point2StationMap.end())
        {
            node.si = st->second;
            node.stationsInPath = 1;
            comeToStation = true;
            if (curve == 0)
            {
                node.curve = curve = node.si->curve;
                if (curve)
                {
                    n = curve->findPointEps(p, 0);
                    if (n == -1)
                    {
                        return false;
                    }
                    node.n = n;
                }
            }
        }

        if (parent)
        {
            node.c1 = parent->c1;
            node.c2 = parent->c2;
            node.stationsInPath += parent->stationsInPath;
            double len = (parent->point - p).Len();
            node.predNode = parent;
            node.len = parent->len+len;

            //расчет весов
            if (eps > 0)//пришли с прыжка между соседними станциями
            {
                node.len2 = parent->len2+len*len;
                node.wlen = parent->wlen+5*len;
                node.jump = parent->jump+1;
                node.jumpslen = parent->jumpslen;
            }
            else if (curve && curve == parent->curve && std::abs(n-parent->n)==1)
            {
                node.len2 = parent->len2;
                node.wlen = parent->wlen+node.getCoef()*len;
                node.lenFromStation += len;
                node.jump = parent->jump;
                node.jumpslen = parent->jumpslen;
            }
            else
            {
                node.len2 = parent->len2;
                node.wlen = parent->wlen+10*len;
                node.lenFromStation +=  len;
                node.jump = parent->jump;
                if (len > 0)
                    node.jump++;
                node.jumpslen = parent->jumpslen+len;
            }
        }
        if (comeToStation)
        {
            node.len2 += node.lenFromStation*node.lenFromStation;
            node.lenFromStation = 0;
        }

        if (node.len+(node.point - node.p1).Len() > 5*d)
            return false;
        if (node.Rast() > maxrast)
            return false;

        SetKey key(curve, p, node.n);
        std::map<SetKey, SetNode>::iterator find = setNodes.find(key);
        if (find != setNodes.end()) //мы уже были в этом узле
        {
            if (find->second.node->Rast() > node.Rast()) //но предыдущий результат хуже
            {
                nodes.push_back(node);
                find->second.node = &nodes.back();
                queue.push(HeapNode(&nodes.back()));
                return true;
            }
            return false;
        }
        nodes.push_back(node);
        setNodes[key] = SetNode(&nodes.back());
        queue.push(HeapNode(&nodes.back()));
        return true;
    }

    int CurveMap::calcP2PCurve(std::ostream& log, Nodes& nodes, const Curve* c1, const Point2d p1, const Curve* c2, const Point2d p2, Points2d& resCurve, const double eps)
    {
        nodes.clear();
        int n1 = (c1)?c1->findPointEps(p1, 0):-1;
        int n2 = (c2)?c2->findPointEps(p2, 0):-1;
        double d = (p1-p2).Len();

        SetNodes setNodes;	//лучший результат для каждой точки
        Queue queue;		//фронт точек

        bool added = addNode(p1, p2, d, 0, c2, n2, p2, nodes, setNodes, queue, 100*d);
        if (added)
        {
            nodes.back().c1 = c1;
            nodes.back().c2 = c2;
        }

        SetKey key(c1, p1, n1);
        std::map<SetKey, SetNode>::iterator find;
        while (!queue.empty() && nodes.size() < 990000)
        {
            Node* parent = queue.top().node;
            Node par = *parent;
            queue.pop();

            double r = 100*d;
            find=setNodes.find(key);//))// == setNodes.end()
            if (find != setNodes.end())
                r = find->second.node->Rast();

            //назад по кривой
            if (parent->curve)
            {
                int i = parent->n - 1;
                if (i >= 0)
                    added = addNode(p1, p2, d, parent, parent->curve, i, parent->curve->points[i], nodes, setNodes, queue, r);
            }

            //вперед по кривой
            if (parent->curve)
            {
                int i = parent->n+1;
                if (i < (int)parent->curve->points.size())
                    added = addNode(p1, p2, d, parent, parent->curve, i, parent->curve->points[i], nodes, setNodes, queue, r);
            }

            //скоки на соседние кривые
            //логарифмическим поиском находим куда мы можем перескочить из нашей точки
            //и перескакиваем
            if (parent->curve)
            {
                Point2CurvePoint pcp;
                pcp.from = parent->point;
                Point2CurvePoints::const_iterator first = std::lower_bound(parent->curve->neigCurves.begin(), parent->curve->neigCurves.end(), pcp);
                for (; first != parent->curve->neigCurves.end() && first->from == parent->point; ++first)
                    added = addNode(p1, p2, d, parent, first->to.curve, first->to.n, first->to.point, nodes, setNodes, queue, r);
            }

            //если в нашей точке есть станция
            //то из нее допустимо прыгать на соседние станции
            if (par.si)
            {
                std::vector<const ::Pathfinder::StationInfo*>::const_iterator sit;
                for (sit = par.si->nearestStations.begin(); sit != par.si->nearestStations.end(); ++sit)
                {
                    added = addNode(p1, p2, d, parent, 0, -1, (*sit)->location, nodes, setNodes, queue, r, eps);
                }
            }
        }
        //обратный ход поиска
        resCurve.clear();
        find = setNodes.find(key);
        if (find != setNodes.end()) //мы уже были в этом узле
        {
            log << "nodes size " << nodes.size() << std::endl;
            for (const Node* node = find->second.node; node; node = node->predNode)
            {
                resCurve.push_back(node->point);
            }
            return 0;
        }
        if (nodes.size() >= 990000)
        {
            log << "too long curve d1=" << (queue.top().node->point - p1).Len() << " d2=" << (queue.top().node->point - p2).Len() << " d=" << d << " queuesizze=" << queue.size() << std::endl;
            return 3;
        }
        log << "no path " << nodes.size() << "\td=\t" << d << std::endl;
        return 2;
    }

    int Curve::simplifi()
    {return 0;}

}
