#ifndef GET_H1
#define GET_H1

//#include "dates.h"
#include "transport.h"

namespace Pathfinder
{
    // разбираем get-запросы
    class Get
    {
    private:
        // храним ключи для пар "ключ-значение"

        // тип начальной станции (станция или город)
        static const std::string fromType;
        // идентификатор начальной станции
        static const std::string fromID;
        // тип конечной станции (станция или город)
        static const std::string toType;
        // идентификатор начальной станции
        static const std::string toID;
        // дата отправления с начальной станции (по Москве)
        static const std::string date;
        // тип транспорта
        static const std::string transport;
        // время на "нулевую пересадку"
        static const std::string boarding;
        // минимальное время на пересадку
        static const std::string minDelay;
        // максимальное время на пересадку
        static const std::string maxDelay;
        // максимальное количество пресадок
        static const std::string maxTransfers;
        // оптимизация по времени или по деньгам? (пока предполагается, что по времени)
        static const std::string optimization;
        // максимальное отклонение результатов поиска
        static const std::string delta;
        // станция
        static const std::string station;
        // оптимизируем по времени
        static const std::string time;
        //режим допустимых пересадок
        static const std::string iLoveSport;
        //для внутригородских пересадок
        static const std::string canChangeInStartTown;
        static const std::string canChangeInFinishTown;
        static const std::string canChangeInAnyTown;
        //режим работы
        static const std::string mode;
        //пересадки с учетом цен
        static const std::string usePrice;
        //максимально-допустимое время обработки одного запроса
        static const std::string timeLimit;
#ifdef DEBUG_ROUTE
        //для отладочной выдачи "почему такого маршрута нет в выдаче"
        static const std::string debugStation;
        static const std::string debugRoute;
#endif

    public:
        // тут храним результаты разбора get-запроса
        // ниже указаны ключи и возможные значения

        // from_type={settlement, station}
        bool _fromIsStation;
        // from_id=Integer
        int  _fromID;
        // to_type={settlement, station}
        bool _toIsStation;
        // to_id=integer
        int  _toID;
        // date=2008-04-10+00%3A00%3A00
        // date=2008-04-01%2000:00:00
        int _startTime;
        // ttype=Integer
        // допустимо несколько типов транспорта
        Transport::Type _transport;
        // boarding=Integer
        int _boarding;
        // min_delay=Integer
        int _minDelay;
        // max_delay=Integer
        int _maxDelay;
        // max_transfers=Integer
        int _numOfChanges;
        // optimize={time, cost}
        bool _optimizeTime;
        // delta=Integer
        int _delta;
        // 
        bool _iLoveSport;
        // mode = {common, wizard, many_days}
        std::string _mode;
        // время, в которое должен уложиться пересадочник в микросекундах
        int _timeLimit;
        //для внутригородских пересадок
        bool _canChangeInStartTown;
        bool _canChangeInFinishTown;
        bool _canChangeInAnyTown;

#ifdef DEBUG_ROUTE
        std::vector<int> _debugStationIDs;
        std::vector<std::string> _debugRoutes;
#endif

        bool _ping;
        bool _usePrice;

        std::string _dateOfStart;
    public:
        // конструктор
        Get(): _fromIsStation(false), _fromID(-1), _toIsStation(false), _toID(-1),
               _startTime(-1), _transport(Transport::NONE), _boarding(-1), _minDelay(-1), _maxDelay(-1),
               _numOfChanges(-1), _optimizeTime(false), _delta(-1), _iLoveSport(false), _timeLimit(-1),
               _canChangeInStartTown(false), _canChangeInFinishTown(false), _canChangeInAnyTown(false),
               _ping(false), _usePrice(false) {}
        // деструктор
        ~Get(){}

    public:
        // загрузить (в том числе и распарсить)
        void load(const std::string & in);

    private:
        // вырезаем из строки get-запрос
        // в случае неудачи возвращаем пустую строку
        static std::string _cutQuery(const std::string & in);
        // разбор и добавление пар ключ-значение
        bool _add(const std::string & portion);
    };
}

#endif

