#include "pathstorage.h"
//#include "wstation.h"
#include "condition.h"

namespace Pathfinder
{
    struct WStation
    {
        // конструктор
        WStation()
            : sci(0)
            {}
        // конструктор
        WStation(StationCalcInfo* sci0)
            : sci(sci0)
            {}

        // ничем разумным не инициализировано
        bool empty() const
        {
            return sci==0 || sci->est.empty();
        }
        // оператор сравнения
        bool operator<(const WStation & ws) const 
        {
            return !(ws.sci->est <= sci->est);
        }
        StationCalcInfo* sci;
    };
    typedef std::vector<WStation> WFront;

    // инициализация массива оценок снизу на вес маршрута до станции назначения на указанных типах транспорта
    int	PathStorage::initEstimations(const StationGraph& sg, const Condition & condition, const Transport::Type& transport
            , const size_t firstBegDay, const size_t lastBegDay, const size_t lastTripDay)
    {
        // резервируем память, заполняем -1
        Departures DEP;
        const size_t d1 = DEP.toOurDay(firstBegDay);
        const size_t d2 = DEP.toOurDay(lastTripDay);
        SearchHelper SH(d1, d2);

        // фронт для хранения станций
        WFront front;
        WFront frontTown;
        WFront frontNext;
        // добавляем станцию к фронту
        for (size_t i = 0; i < condition.getTo().size(); i++)
            if (condition.getTo()[i]->transports & transport)
            {
                Estimation zeroest(0);
                _station2Info[condition.getTo()[i]->id1].est = zeroest;
                front.push_back(WStation(&_station2Info[condition.getTo()[i]->id1]));
            }

        int flag = false;
        _timer.start();
        int iFront = 0;
        for (; iFront < MAX_CHANGES; iFront++)
        {
            for (int i = 0; i < front.size(); i++)
            {
                _timer.stop();
                if (_timer.getTime() > _timeLimitInit) {
                    stopExecutionByTimeLimit();
                    return iFront;
                }

                const StationCalcInfo* current = front[i].sci;
                const TripInfoPtrs& info(sg._invGraph[current->si->id1].startTIs);
                TripInfoPtrs::const_iterator infoEnd = info.end();
                for (TripInfoPtrs::const_iterator ti = info.begin(); ti != infoEnd; ++ti)
                {
                    //выходим с tripinfo
                    const TripInfo* tripinfo = *ti;
                    if ((tripinfo->transport & transport))// && tripinfo->departures.isGoodDay(SH))
                    if (tripinfo->stopOnLastStation())// && !tripinfo->townsGoodForOut.empty())
                    if (iFront > 0
                        || tripinfo->stationInfoTo == condition._toStation
                        || (condition._toStationIsTown && tripinfo->townGoodForFinish(condition._toStation, TeleportLink::START)))
                    {
                        //_runByThread(*ti);
                        Estimation newest = current->est;
                        newest.changes++;
                        newest.trPoint += Transport::getWeight(tripinfo->transport);
                        int duration = 0;
                        int predDiscomfort = newest.discomfort;

                        if (iFront>0)
                        {
                            int transportDelay = Transport::getMinDelay(condition._minDelayOut, tripinfo->transport);
                            newest.weight += transportDelay;
                        }
                        //едем на tripinfo
                        for (; tripinfo; tripinfo = tripinfo->predTI)
                        if (tripinfo->departures.isGoodDay(SH))
                        {
                            newest.weight += tripinfo->duration;
                            duration += tripinfo->duration;
                            newest.discomfort = predDiscomfort + Transport::getDiscomfort(tripinfo->transport, duration, 0, tripinfo->threadStart->isMain());
                            if (newest < _edge2Info[tripinfo->id].est)
                            {
                                _edge2Info[tripinfo->id].est = newest;
                                //заходим в tripinfo
                                if (tripinfo->stopOnFirstStation()// && !tripinfo->townsGoodForIn.empty()
//									&& _station2Info[tripinfo->stationInfoFrom->id1].front==0 
                                    )
//									|| (tripinfo->stationInfoFrom->canChange() && !tripinfo->townsGoodForIn.empty()))
                                {
                                    StationCalcInfo& station2Info/*stationEst*/ = _station2Info[tripinfo->stationInfoFrom->id1];
                                    int minDelay = Transport::getMinDelay(condition._minDelayIn, tripinfo->transport);
                                    Estimation telEst = newest;
                                    telEst.weight += minDelay;

                                    if (station2Info.si->majority > 1)
                                        telEst.discomfort++;

                                    telEst.plusPrice(sg.getBestPrice(tripinfo->stationInfoFrom, current->si));
                                    if (telEst < station2Info.estAndGo)
                                        station2Info.estAndGo = telEst;
                                    if (telEst < station2Info.est)
                                    {
                                        if (station2Info.est.empty())
                                            frontNext.push_back(WStation(&station2Info));
                                        station2Info.est = telEst;
                                        {
                                        //телепортация из центра города
                                        TeleportLinkPtrs::const_iterator townEnd = tripinfo->townsGoodForIn.end();
                                        for (TeleportLinkPtrs::const_iterator town = tripinfo->townsGoodForIn.begin()
                                            ; town != townEnd; ++town)
                                        {
                                            int numCostationsGoodForOut = (*town)->town->getNumCostationsGoodForOut((*town)->si, transport);
                                            if (numCostationsGoodForOut < 1)
                                                continue;
                                            Estimation& townEst = _station2Info[(*town)->town->id1].est;
                                            telEst.weight += (*town)->time2center;
                                            telEst.discomfort += (*town)->time2center;
                                            if (telEst < townEst)
                                            {
                                                if (townEst.empty())
                                                    frontTown.push_back(WStation(&_station2Info[(*town)->town->id1]));
                                                townEst = telEst;
                                            }
                                            telEst.discomfort -= (*town)->time2center;
                                            telEst.weight -= (*town)->time2center;
                                        }
                                        }
                                        telEst.trPoint++;//телепортация
                                        //телепортация из соседних станций
                                        {
                                        TeleportLinks::const_iterator townEnd = tripinfo->stationInfoFrom->costations.end();
                                        for (TeleportLinks::const_iterator town = tripinfo->stationInfoFrom->costations.begin()
                                            ; town != townEnd; ++town)
                                        if (town->town->transports & transport)
                                        {
                                            Estimation& townEst = _station2Info[town->town->id1].est;
                                            telEst.weight += town->time2center;
                                            if (telEst < townEst)
                                            {
                                                if (townEst.empty())
                                                    frontNext.push_back(WStation(&_station2Info[town->town->id1]));
                                                townEst = telEst;
                                            }
                                            telEst.weight -= town->time2center;
                                        }
                                        }
                                    }
                                }
                            }
                            else
                                break;
                            newest.weight += tripinfo->stopTimeBefore;
                            if (tripinfo->nextTI)
                                duration += tripinfo->nextTI->stopTimeBefore;
                        }
                    }
                }
            }
            if (flag)
                break;
            for (StationInfoPtrs::const_iterator startSt = condition.getFrom().begin()
                ; startSt != condition.getFrom().end(); ++startSt)
            {
                if (!_station2Info[(*startSt)->id1].est.empty())
                {
                    flag = true;
                    break;
                }
            }
            //телепортации
            for (int i = 0; i < frontTown.size(); i++)
            {
                Estimation& newest = frontTown[i].sci->est;
                const TeleportLinks& costations = frontTown[i].sci->si->costations;
                for (int j = 0; j < costations.size(); j++)
                if (costations[j].isGoodForFinish)
                if (costations[j].si->transports & transport)
                {
                    Estimation& townEst = _station2Info[costations[j].si->id1].est;
                    Estimation telEst = newest;
                    telEst.trPoint++;
                    telEst.weight += costations[j].time2center;
                    telEst.discomfort += costations[j].time2center;
                    telEst.plusPrice(TELEPORTATION_PRICE);
                    if (telEst < townEst)
                    {
                        if (townEst.empty())
                            frontNext.push_back(WStation(&_station2Info[costations[j].si->id1]));
                        townEst = telEst;
                    }
                }
            }
            if (flag)
                break;
            front.swap(frontNext);
            std::sort(front.begin(), front.end());
            frontNext.clear();
            frontTown.clear();
        }
        return iFront;
    }

    // сохраняем вычисленные оценки
    void PathStorage::_saveEstimations(const char * filePath) const
    {
        std::ofstream fout(filePath);
        for (size_t i = 0; i < _station2Info.size(); ++i)
        {
            fout << i << '\t';
            _station2Info[i].est.save(fout);
            fout << std::endl;
        }
    }

}
