#pragma once
#if !defined(PF_H)
#define PF_H

// подключаемые библиотеки
#include <string>
#include <string.h>
#include <vector>
#include <queue>
#include <numeric>
#include <set>
#include <map>
#include <fstream>
#include <sstream>
#include <queue>
#include <cmath>
#include <iomanip>
#include <algorithm>
#include <list>
#include <memory>
#include <assert.h>

#include "base.h"
#include "timer.h"

// вводим синоним для пространства имен Pathfinder
namespace Pathfinder {}
namespace PF = Pathfinder;

//#define DEBUG_PRINT
#define LOG_FILE_NAME "log.log"

//#define DEBUG_ROUTE
#define DEBUG_LOG_FILE "debug_log.log"

//#define FOR_WIZARD
#ifdef FOR_WIZARD
    // максимальное количество пересадок (<)
    #define MAX_CHANGES         3
#else
    #define MAX_CHANGES    10
    //#define PRICES_ON
    #define DISCOMFORT_ON
    //#define DISCOMFORT_STR_ON
#endif

#define EPS_SHIFT           5
#define TELEPORTATION_PRICE 30000   //копеек

// минимальное значение идентификаторов городов
// почему 8000 ? - чтобы отличать от станций (id-ки городов начинаются с 8000)
// число 8000 есть в python-скрипте ( www/db/scripts/gen-pathfinder-data.py)
//TODO: некрасиво
#define MIN_TOWN_ID 8000

// временнЫе константы
// основная единица измерения времени - минута

// начало отсчета - 1-е января 2008 года 00:00
#define ORIGIN_YEAR         2008
// количество месяцев в году
#define MONTHS_IN_YEAR      12
// количество дней в не високосном годды
#define DAYS_IN_YEAR_UNLEAP 365
// количество дней в високосном году
#define DAYS_IN_YEAR_LEAP   (DAYS_IN_YEAR_UNLEAP + 1)
// количество дней в маске в прошлом
#define DAYS_TO_PAST 30
// количество секунд в минуте
// используется для проверки
#define SECONDS_IN_MINUTE   60
// количество минут в часе
#define MINUTES_IN_HOUR     60
// количество часов в дне
#define HOURS_IN_DAY        24
// количество минут в дне
#define MINUTES_IN_DAY      (MINUTES_IN_HOUR * HOURS_IN_DAY)
#define MAX_TRIP_DAYS       10
#define MAX_TRIP_TIME       (MAX_TRIP_DAYS*MINUTES_IN_DAY)

// константы, ограничивающие выделение памяти
// максимальное количество путей, возникающих при поиске
#define MAX_NUM_OF_PATHS    300000
// максимальное количество сегментов путей, возникающих при поиске (сумма по всем сегментам по всем путям)
#define MAX_NUM_OF_VERTICES 3000000
// если при поиске мы потратили уже больше MAX_WAIT путей и ничего не нашли, то выходим
#define MAX_WAIT            MAX_NUM_OF_PATHS
// если при поиске мы потратили уже больше MAX_WAIT_SUCCESS путей и нашли, то выходим
#define MAX_WAIT_SUCCESS    300000
// если при поиске мы уже нашли MAX_RES путей, то выходим
#define MAX_RES             1000

//максимальное число пересадок, на которое расчитан алгоритм (используется при упаковке в биты)
#define MAX_CH              0xF
//максимальная цена
#define MAX_PRICE           0xFFFFFFF
#define MAX_DISCOMFORT      0xFFFF

// константы для вычисления Удобства
#define U_MOVE                  48*60   //неудобно непрерывно ехать более двух суток
#define U_MOVE_NO_SLEEP         6*60    //ехать сидя неудобно более 6 часов
#define U_MOVE_NO_SLEEP_NIGHT   0       //ехать сидя ночью неудобно более 2 часов
#define U_MOVE_TICKET_BOOK      30      //полчаса времени займут бронинование билета на самолет или поезд
#define U_MOVE_THRO_CAR         1       //штраф за беспересадочный вагон

#define U_STATION_WARM          20      //пересадка в поле более 20 минут неудобна
#define U_STATION_WC            60      //без туалета грустно час
#define U_STATION_EAT           4*60    //без еды - 4 часа
#define U_STATION_SLEEP_NIGHT   2*60    //ночью без сна - 2 часа

#define U_TELEPORT              0

// проверка выполнения условия condition
// в случае невыполнения - печать в stderr и возбуждение исключения
//TODO: заменить вывод в stderr на вывод в лог
#define PF_ASSERTION(condition, message, integer) \
{ \
    if(!(condition)) \
    { \
        fprintf(stderr, "PF_ASSERTION failed\n\tFILE=%s\n\tFUNCTION=%s\n\tLINE=%d\n\tCONDITION=%s\n\tMESSAGE=%s\n\tINTEGER=%ld\n", __FILE__, __FUNCTION__, __LINE__, #condition, message, (long int)integer); \
        throw ""; \
    } \
}

// замеряем время
#define TIMING


#endif

