#ifndef _P_QUEUE_
#define _P_QUEUE_

#include <algorithm>
#include <deque>
#include <functional>
#include <vector>


namespace Pathfinder
{
    // TEMPLATE CLASS priority_queue
    template<class _Ty,
            class _Container = std::vector<_Ty>
//	,class _Pr = std::less<typename _Container::value_type> 
    >
    class priority_queue
    {	// priority queue implemented with a _Container
    public:
        typedef _Container container_type;
        typedef typename _Container::value_type value_type;
        typedef typename _Container::size_type size_type;
        typedef typename _Container::reference reference;
        typedef typename _Container::const_reference const_reference;

        bool empty() const
        {	// test if queue is empty
            return (c.empty());
        }

        size_type size() const
        {	// return length of queue
            return (c.size());
        }

        const_reference top() const
        {	// return highest-priority element
            return (c.front());
        }

        reference top()
        {	// return mutable highest-priority element (retained)
            return (c.front());
        }

        template <class _Pr>
        void push(const value_type& _Pred, _Pr comp)
        {	// insert value in priority order
            c.push_back(_Pred);
            std::push_heap(c.begin(), c.end(), comp);
        }

        template <class _Pr>
        void pop(_Pr comp)
        {	// erase highest-priority element
            std::pop_heap(c.begin(), c.end(), comp);
            c.pop_back();
        }

        void clear()
        {	// erase all elements
            c.clear();
        }

        template <class _Pr>
        void changeComparator(_Pr comp)
        {
            std::make_heap(c.begin(), c.end(), comp);
        }

    protected:
        _Container c;	// the underlying container
//	_Pr comp;	// the comparator functor
    };
}
#endif /* _QUEUE_ */
