#if !defined(RECODE_H)
#define RECODE_H

#include "pf.h"
#include <map>

namespace Pathfinder
{
    // перекодируем
    template <class A, class B>
    class Recode
    {
    public:
        // кодируем туда
        typedef std::map<A, B> Timap;
        Timap imap;
        // кодируем обратно
        typedef std::map<B, A> Timapback;
        Timapback imapback;
        // максимальный код
        A maxA;
        Recode() : maxA(0)
        {}
        // загружаем данные, возвращаем кол-во загруженных записей или -1 в случае неудачи
        int load(const char * filePath)
        {
            std::ifstream fin(filePath);
            // -1 если неудача
            if (fin.fail())
                return -1;

            // загружаем
            A first;
            B second;
            int count(0);
            while (fin >> first >> second)
            {
                imap[first] = second;
                imapback[second] = first;
                ++count;
            }
            return count;
        }

        A addNext(const B& b)
        {
            typename Timapback::const_iterator it = imapback.find(b);
            if (it != imapback.end())
                return it->second;
            imapback[b] = maxA;
            imap[maxA] = b;
            maxA++;
            return maxA-1;
        }

        void clear() {
            imap.clear();
            imapback.clear();
            maxA = 0;
        }

        void deleteLastItem() {
            maxA--;
            imapback.erase(imap[maxA]);
            imap.erase(maxA);
        }

        size_t size() const
        {
            return imap.size();
        }

    };
}

#endif

