#include <string.h>

#include "result.h"

namespace Pathfinder
{
    // сортируем по пересадкам (getNumberOfChanges)
    void
    Result::sortByChanges()
    {
		std::sort(_paths.begin(), _paths.end(), Path::cmpByChanges);
    }

    // обертывем строку в HTTP-ответ
    void
    Result::wrap(std::string & str)
    {
        const size_t len(str.size());
        const size_t sz(32);
        char buffer[sz];
        #ifdef _win32_
        sprintf_s(buffer, "Content-Length: %u\r\n", static_cast<unsigned int>(len));
        #else
        sprintf(buffer, "Content-Length: %u\r\n", static_cast<unsigned int>(len));
        #endif

        const std::string contentLength(buffer);

        std::string answer;
        answer += "HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n";
        answer += contentLength;
        answer += "\r\n";
        answer += str;

        str.swap(answer);
    }

    std::string Result::toString(const StationTown& st) const
    {
        std::string res;
//      for (size_t i = 0; i < _paths.size(); ++i)
//          res += _paths[i].toString(st) + '\n';
			return res;
    }

}

