#if !defined(RESULT_H)
#define RESULT_H

#include "path.h"
#include "stationtown.h"
#include "priority_queue.h"

namespace Pathfinder
{
    // храним и обрабатываем результаты
    class Result
    {
        friend class TheGraph;

    public:
        // пути, которые нашли
        Pathes _paths;
        std::vector<Estimation::BetterItem> betters;
        Estimations _est;

        void clear()
        {
            _paths.clear();
        }

        void clearPathes()
        {
            std::sort(_paths.begin(), _paths.end(), Path::cmpByChangesAndTime);
            Pathes::iterator it1;
            for (it1 = _paths.begin(); it1 != _paths.end() && !it1->empty(); ++it1);
            if (it1 != _paths.end())
                _paths.erase(it1, _paths.end());

        }

        bool addResult2Set(Path& path)
        {
            int inserted = 0, iEps = 0;
            int deleted = 0, dEps = 0;
            betters.resize(_paths.size());
            std::fill(betters.begin(), betters.end(), Estimation::NONE);
            int i = 0;
            Pathes::iterator itB = _paths.end();
            for (Pathes::iterator it = _paths.begin(); it != _paths.end(); ++it, i++)
            {
                Estimation::BetterItem better = it->getLastVertex()->better4ByObt(*path.getLastVertex());
                betters[i] = better;
                if (better & Estimation::BETTER)
                {
                    deleted++;
                    if (better & Estimation::EPS)
                        dEps++;
                    else
                        itB = it;
                }
                else if (better & Estimation::WORSE)
                {
                    inserted++;
                    if (better & Estimation::EPS)
                        iEps++;
                }
                else if (better == Estimation::ANY)
                {
                    if (deleted)
                    {
                        deleted++;
//                        dEps++;
                    }
                    else
                    {
                        inserted++;
//                        iEps++;                    
                    }
                }
//                if (path.getObt().weight==961)
//                {
//#ifdef DEBUG_PRINT
//{
//std::fstream out("log.txt", std::ios::out | std::ios::app);
//out << "RES strange" << better << " with " << *it->getLastVertex() << std::endl;
//for (const Vertex* v = it->getLastVertex(); v; v = v->getPrevious())
//    out << "RES b " << *v << std::endl;
//}
//#endif
//                }
            }
            i = 0;
            bool doDel = (deleted > dEps) || (deleted == dEps && inserted == iEps && deleted && inserted);
            if (inserted > iEps && deleted == 0)
            for (Pathes::iterator it = _paths.begin(); it != _paths.end(); ++it, i++)
            {
                Estimation::BetterItem better = betters[i];
                if (better & Estimation::WORSE)
                {
#ifdef DEBUG_ROUTE
{
    std::fstream out(DEBUG_LOG_FILE, std::ios::out | std::ios::app);
    out << "RES deleted " << *it->getLastVertex() << std::endl;
}
#endif
                    it->withdraw();
                    *it = Path();
                }
                else if (better == Estimation::ANY)
                {
#ifdef DEBUG_ROUTE
{
std::fstream out(DEBUG_LOG_FILE, std::ios::out | std::ios::app);
out << "RES deleted " << *it->getLastVertex() << std::endl;
}
#endif
                    it->withdraw();
                    *it = Path();
                }
            }
            
#ifdef DEBUG_ROUTE
{
std::fstream out(DEBUG_LOG_FILE, std::ios::out | std::ios::app);
if (inserted > iEps && deleted > 0)
{
    out << "RES strange ";
    path.toString(out);
}
if (!doDel)
{
    out << "RES added ";
    path.toString(out);
}
else
{
    out << "RES not added ";
    path.toString(out);
    if (itB != _paths.end())
    {
        out << " by " << std::flush;
        itB->toString(out);
    }
}
}
#endif
            if (!doDel)
            {
                path.setZeroEst();
                _paths.push_back(path);
            }
            clearPathes();
#ifdef DEBUG_ROUTE
{
std::fstream out(DEBUG_LOG_FILE, std::ios::out | std::ios::app);
out << " (" << _paths.size() << ")" << std::endl;
}
#endif
            return true;
        }

        bool checkByResultTotalEst(const Path & path)
        {
            for (Pathes::iterator it = _paths.begin(); it != _paths.end(); ++it)
                if (it->getLastVertex()->better4ByTotalObt(*path.getLastVertex()) & (Estimation::BETTER | Estimation::ANY))
                    return false;
            return true;
        }

    public:
        // добавить путь
        void addPath(const Path & path) 
        { 
            _paths.push_back(path); 
        }
        void addPathCopy(Path & path) 
        { 
            if (addResult2Set(path))
                path.getLastVertex()->increaseAllReferences();
        }
        // вернуть размер
        size_t size() const { return _paths.size(); }
        // пуст или нет
        bool empty() const { return _paths.empty(); }

    public:
        // сортируем по пересадкам (getNumberOfChanges)
        void sortByChanges();
        // сортируем по времени (getTotalTime)
        void sortByTime() { std::sort(_paths.begin(), _paths.end(), Path::cmpByObt);}
        // очищаем
        void erase() { _paths.erase(_paths.begin(), _paths.end()); }
        // передергиваем
        void reset() 
        { 
            _paths.clear(); 
            _est.clear();
        }
        // вернуть пути
        std::vector<Path> & getPaths() { return _paths; }
        // обертывем строку в HTTP-ответ
        static void wrap(std::string & str);
        // корректность
        bool isValid () const { return true; }
        // перекодируем идентификаторы станций
//        static void recodeStations(const Recode<int, int>& recode, std::vector<Result> & results);
        // делаем swap
        void swap(Result & res)
        {
            _paths.swap(res._paths);
        }
        /// напечатать все пути с дополнительными данными
        std::string toString(const StationTown& st) const;
        int getBestChanges() const
        {
            if (_paths.empty())
                return 0;
            return _paths[0].getLastVertex()->getTotalChanges();
        }
        size_t getBestChangesNumber() const
        {
            if (_paths.empty())
                return 0;
            int bc = _paths[0].getLastVertex()->getObt().changes;
            size_t i;
            for (i = 0; i < size() &&  _paths[i].getLastVertex()->getObt().changes == bc; i++);
            return i;
        }
        int getPricedNumber() const
        {
            int res = 0;
            for (int i = 0; i < size(); i++)
                if (_paths[i].getLastVertex()->getObt().price < MAX_PRICE)
                    res++;
            return res;
        }
        int getBestTime() const
        {
            int res = MAX_TRIP_TIME;
            for (int i = 0; i < size(); i++)
                res = std::min(res, _paths[i].getLastVertex()->getObt().weight);
            return res;
        }
        float getBestPrice() const
        {
            int res = MAX_PRICE;
            for (int i = 0; i < size(); i++)
                res = std::min(res, _paths[i].getLastVertex()->getObt().price);
            if (res == MAX_PRICE)
                return -1;
            return res*0.01;
        }
        int getBestDiscomfort() const
        {
            int res = MAX_DISCOMFORT;
            for (int i = 0; i < size(); i++)
                res = std::min(res, _paths[i].getLastVertex()->getObt().discomfort);
            return res;
        }
        void cutByOneDay(const std::string& LOG_FILE, const int b, const int e)
        {
//            message(LOG_FILE, "cut with e= ", e);
            for (Pathes::iterator it = _paths.begin(); it != _paths.end(); ++it)
            {
//                message(LOG_FILE, "cut path with begtime= ", it->getLastVertex()->getObt().begTime);    
                if (it->getLastVertex()->getObt().begTime > e)
                {
//                    message(LOG_FILE, "done cut", it->getLastVertex()->getObt().begTime);
                    it->withdraw();
                    *it = Path();
                }
            }
            std::sort(_paths.begin(), _paths.end(), Path::cmpByChangesAndTime);
            Pathes::iterator it1;
            for (it1 = _paths.begin(); it1 != _paths.end() && !it1->empty(); ++it1);
            if (it1 != _paths.end())
                _paths.erase(it1, _paths.end());
        }
};

    // много результатов
    typedef std::vector<Result> Results;
}
#endif

