#include <assert.h>
#include "stationgraph.h"

namespace Pathfinder
{
	size_t saveCurve(std::ostream& out, const Geom::Curve& curve, const Geom::Point2d& a, const Geom::Point2d& b)
	{
		size_t res = 0;
		if (!curve.points.empty())
		{
			res += curve.savePointsList(out);
			out << std::endl;
		}
		else 
		{
			out << a.x << " " << a.y 
				<< " " 
				<< b.x << " " << b.y 
				<< std::endl;
			res+=2;
		}
		return res;
	}

	size_t StationGraph::saveEdge2Curve(std::ostream& out, const Transport::Type trFilter)
	{
		size_t res = 0;
        for(size_t i = 0; i < _graph.size(); ++i)
            for (size_t j = 0; j < _graph[i].sais.size(); ++j)
			{
				StationAndInfo& sai = _graph[i].sais[j];
				if (sai.transports & trFilter)
				{
					const StationInfo* to = sai.stationTo;
					Geom::Point2d a = st.stationInfos[i].location;
					Geom::Point2d b = to->location;

					if (a != Geom::Point2d(0) && b != Geom::Point2d(0))
					{
						if (sai.curve.used)
						{
							out << st.stationInfos[i].id << "\t" << to->id << "\tnone\t";
							res += saveCurve(out, sai.curve, a, b);
						}

						std::map<std::string, Geom::Curve>::iterator it = sai.routeCurves.begin();
						std::map<std::string, Geom::Curve>::iterator itEnd = sai.routeCurves.end();
						for (; it != itEnd; ++it)
						{
							if (it->second.used)
							{
								out << st.stationInfos[i].id << "\t" << to->id << "\t" << it->first;
								double len = it->second.getLen();
								for (std::map<std::string, Geom::Curve>::iterator it1 = it; it1 != itEnd; ++it1)
										if (it1->second.getLen() == len)
										{
											out << "," << it1->first;
											it1->second.used = false;
										}
								out << "\t";
								res += saveCurve(out, it->second, a, b);
							}
						}
					}
				}
			}
		return res;
	}

	size_t StationGraph::getThreadsBegining(const Neighbours& neigs, const Transport::Type trFilter)
	{
		size_t res = 0;
		for (Neighbours::const_iterator itN = neigs.begin(); itN != neigs.end(); ++itN)
			for (Info::const_iterator itI = itN->info.begin(); itI != itN->info.end(); ++itI)
				if ((*itI)->predTI == 0 && (*itI)->transport & trFilter)
					res++;
		return res;
	}

	size_t StationGraph::getThreadsEnding(const Neighbours& neigs, const Transport::Type trFilter)
	{
		size_t res = 0;
		for (Neighbours::const_iterator itN = neigs.begin(); itN != neigs.end(); ++itN)
			for (Info::const_iterator itI = itN->info.begin(); itI != itN->info.end(); ++itI)
				if ((*itI)->nextTI == 0 && (*itI)->transport & trFilter)
					res++;
		return res;
	}

	size_t StationGraph::interpolateEmptyStationLocation(std::ostream& log, const Transport::Type trFilter)
	{
		size_t n = getStationNumber();
		StationLocLens stloc;
		stloc.resize(n);
		std::fill(stloc.begin(), stloc.end(), StationLocLen());

		StationLocTimes sis;
		for (ThreadStarts::iterator it = _threadStart.begin(); it != _threadStart.end(); ++it)
			if (it->transports & trFilter) {
				it->getStationsWithLocation(sis);
				it->interpolateStationsWithOutLocation(sis, stloc);
			}

		size_t res = 0;
		for (size_t i = 0; i < n; i++)
			if (stloc[i].n)
			{
				st.stationInfos[i].location = (1.0/stloc[i].n)*stloc[i].loc;
				if (st.stationInfos[i].oldLocation.IsZero())
				{
					st.stationInfos[i].oldLocation = st.stationInfos[i].location;
					log << st.stationInfos[i].id << "\t" << st.stationInfos[i].name << "\tinterpolated\t" << st.stationInfos[i].location.x << "\t" << st.stationInfos[i].location.y << std::endl;
				}
				res++;
			}
		for (size_t i = 0; i < n; i++)
			if ((st.stationInfos[i].transports & trFilter) && st.stationInfos[i].location.IsZero())
			{
				if (_graph[i].sais.size() > 0 && _graph[i].sais[0].info.size() > 0)
				{
					size_t begining = getThreadsBegining(_graph[i].sais, trFilter);
					size_t ending = getThreadsEnding(_invGraph[i].sais, trFilter);
					log << st.stationInfos[i].id << "\t" << st.stationInfos[i].name << "\tempty_loc\t" << _graph[i].sais[0].info[0]->getName();
					if (begining+ending > 0)
						log << "\t" << (begining+ending) << "empty_threads";
					log << std::endl;
				}
				else
					log<< st.stationInfos[i].id << "\t" << st.stationInfos[i].name << "\tstrange_loc"  << std::endl;
			}
		return res;
	}

	size_t StationGraph::fillShortestPaths(std::ostream& /*log*/, const Transport::Type trFilter)
	{
		calcDists();
		size_t res = 0;
		for (ThreadStarts::iterator it = _threadStart.begin(); it != _threadStart.end(); ++it)
			if (it->transports & trFilter)
			{
				res += it->fillShortestPaths(_graph);
			}
		return res;
	}

	size_t StationGraph::fillLongCurves2(std::ostream& log, const Transport::Type trFilter)
	{
		calcDists();
		size_t res = 0;
		for (ThreadStarts::iterator it = _threadStart.begin(); it != _threadStart.end(); ++it)
			if (it->transports & trFilter)
			if (it->startTI->isHelper())
			{
				res += fillLongCurvesByThread(log, it->startTI, trFilter);
			}
		for (ThreadStarts::iterator it = _threadStart.begin(); it != _threadStart.end(); ++it)
			if (it->transports & trFilter)
			if (!it->startTI->isHelper())
			{
				const TripInfo* startTI = it->startTI;
				for (const TripInfo* ti1 = startTI; ti1; ti1 = ti1->nextTI)
				{
					std::map<std::string, Geom::Curve>::const_iterator find = ti1->sai->routeCurves.find(ti1->getRoute());
					if (find != ti1->sai->routeCurves.end())
						find->second.used = true;
					else
						ti1->sai->curve.used = true;
				}
			}
		return res;
	}

	size_t StationGraph::fillLongCurvesByThread(std::ostream& log, const TripInfo* startTI, const Transport::Type /*transports*/)
	{
		size_t res = 0;
		for (const TripInfo* ti1 = startTI; ti1; ti1 = ti1->nextTI)
		{
			int n = 2;
			for (const TripInfo* ti2 = ti1->nextTI; ti2; ti2 = ti2->nextTI, n++)
			{
				Neighbours::iterator sai = _graph[ti1->stationInfoFrom->id1].sais.begin();
				Neighbours::iterator itEnd = _graph[ti1->stationInfoFrom->id1].sais.end();
				for (; (sai != itEnd) && sai->stationTo != ti2->stationInfoTo; ++sai);

				//���� �� ����� ���-��
				if (sai == itEnd)
					continue;

				Info::iterator iit = sai->info.begin();
				Info::iterator iitEnd = sai->info.end();
				for (; (iit != iitEnd) && ((*iit)->isHelper() || (*iit)->getRoute() != startTI->getRoute()); ++iit);
				if (iit == iitEnd)
					continue;

				Geom::Curve curve;
				Geom::Point2d loc;
				const StationInfo* to = ti2->stationInfoTo;
				log << "curve_constr\t" << sai->info[0]->stationInfoFrom->id << "\t" << sai->info[0]->stationInfoTo->id << "\t" << startTI->getRoute() << "\tfrom "
					<< sai->info[0]->stationInfoFrom->name << " to " << sai->info[0]->stationInfoTo->name << "\tdist=" << sai->dist << " path=\t";
				const TripInfo* predti = ti1;
				const TripInfo* ti = ti1;
				for (ti = ti1; ti && ti->stationInfoFrom != to && predti->stationInfoTo != to; ti = ti->nextTI)
				{
					log << ti->stationInfoFrom->id << "\t" << ti->stationInfoFrom->name << "\t";
					if (ti->sai->curve.points.empty())
					{
						loc = ti->stationInfoFrom->location;
						if (!loc.IsZero() && (curve.points.empty() || curve.points.back() != loc))
							curve.points.push_back(loc);
						loc = ti->stationInfoTo->location;
						if (!loc.IsZero() && (curve.points.empty() || curve.points.back() != loc))
							curve.points.push_back(loc);
					}
					else
					{
						size_t n = ti->sai->curve.points.size();
						for (size_t k = 0; k < n; k++)
						{
							loc = ti->sai->curve.points[k];
							if (!loc.IsZero() && (curve.points.empty() || curve.points.back() != loc))
							{								
								curve.points.push_back(loc);
							}
						}
					}
					predti = ti;
				}
				log << predti->stationInfoTo->id << "\t" << predti->stationInfoTo->name << std::endl;
				if (curve.getLen() != sai->curve.getLen())
				{
					if (curve.getLen() < 5*sai->curve.getLen())
					{
//						log << "curve_2_route " << sai->info[0]->getName() << " with route " << ti1->getName() << "\tlenr=" << curve.getLen() << "\tlennone=" << sai->curve.getLen() << std::endl;
						sai->routeCurves[ti1->getRoute()] = curve;
					}
					else
					{
						log << "wrong auxilary path " << ti1->getName() << " from " << ti1->stationInfoFrom->name << " to " << ti1->stationInfoTo->name << std::endl;
					}
				}
			}
		}
		return res;
	}


#include "curve.h"
	size_t StationGraph::fillCurves(std::ostream& log, Geom::CurveMap& curveMap, const double eps, const Transport::Type trFilter)
	{
		Geom::CurveMap::Nodes nodes;
		nodes.reserve(1000000);
		size_t res = 0;
        for(size_t i = 0; i < _graph.size(); ++i)
		{
			//log << i << "\t" << st.stationInfos[i].name << std::endl;
			for (size_t j = 0; j < _graph[i].sais.size(); ++j)
			{
				StationAndInfo& sai = _graph[i].sais[j];
				const StationInfo* to = sai.stationTo;
				const Geom::Curve* c1 = st.stationInfos[i].curve;
				const Geom::Curve* c2 = to->curve;
				double d = (st.stationInfos[i].location - to->location).Len();
				if ((sai.transports&trFilter) /* sai.nShortEdgeInside == 1 &&  c1 && c2*/)
				{
					int err = curveMap.calcP2PCurve(log, nodes, c1, st.stationInfos[i].location, c2, to->location, sai.curve.points, eps);
					if (err == 2/*no path*/)
							log << d << "\tno path from " << st.stationInfos[i].name << " to " << to->name.c_str() << " thread=" << sai.info[0]->getName() << " d=" << d << std::endl;
					else if (err == 3/*long path*/)		
							log << "long path from " << st.stationInfos[i].name << " to " << to->name.c_str() << " thread=" << sai.info[0]->getName() << " d=" << d << std::endl;
				}

			}
		}
		fillLongCurves2(log, trFilter);
		return res;
	}

	size_t StationGraph::calcDists()
	{
		size_t res = 0;
        for(size_t i = 0; i < _graph.size(); ++i)
			for (size_t j = 0; j < _graph[i].sais.size(); ++j)
			{
				StationAndInfo& sai = _graph[i].sais[j];
				const StationInfo* to = sai.stationTo;
				Geom::Point2d locFrom = st.stationInfos[i].location;
				Geom::Point2d locTo = to->location;
				if (!locFrom.IsZero() && !locTo.IsZero())
				{
					sai.dist = (locFrom-locTo).Len();
					res++;
				}
			}
		return res;
	}

	size_t StationGraph::fillNearestNeigs2(const Transport::Type trFilter)
	{
		size_t res = 0;
        for(size_t i = 0; i < _graph.size(); ++i)
		{
			st.stationInfos[i].nearestStations.clear();
			std::set<const StationInfo*> used;
			for (size_t j = 0; j < _graph[i].sais.size(); ++j)
			{
				StationAndInfo& sai = _graph[i].sais[j];
				const StationInfo* to = sai.stationTo;
				if (sai.transports & trFilter)
				{
					if (used.find(to) == used.end())
					{
						st.stationInfos[i].nearestStations.push_back(to);
						res++;
						used.insert(to);
					}
				}
			}
		}
		return res;
	}

	size_t StationGraph::calcLongestPointPath(std::ostream& log, const Transport::Type trFilter)
	{
		size_t res = 0;
		for (ThreadStarts::iterator it = _threadStart.begin(); it != _threadStart.end(); ++it)
			if (it->transports & trFilter)
			{
				size_t n = it->calcPathPointNumber();
				log << it->getName() << "\t" <<  n << std::endl;
				if (n > res)
					res = n;
			}
		return res;
	}


}
