#if !defined(STATIONLOC_H)
#define STATIONLOC_H

#include "pf.h"
#include "geom.h"

namespace Geom
{
    struct Curve;
}

namespace Pathfinder
{
    struct StationInfo;
    struct StationLocTime
    {
        const StationInfo* stationInfo;
        double time;
        StationLocTime() : stationInfo(0), time(0) {}
    };
    typedef std::vector<StationLocTime> StationLocTimes;


    struct StationLocLen
    {
        ::Geom::Point2d loc;
        int n;
        double minlen;
        std::vector<const Geom::Curve*> curves;
        StationLocLen() : n(0), minlen(0) {}
        bool addCurve(const Geom::Curve* c);
    };
    typedef std::vector<StationLocLen> StationLocLens;


}

#endif

