#include "stationtown.h"
#include "curve.h"

namespace Pathfinder
{
    TeleportLink::TeleportLink(const StationInfo* si1, const StationInfo* town1, const Type t, const int time)
            : stationID1(si1->id1), si(si1), town(town1), type(t), time2center(time), isGoodForStart(false), isGoodForFinish(false)
    {}


    size_t StationTown::saveStationsAsPolish(std::ostream& out, const Transport::Type trFilter, const char* color)
    {
        size_t res = 0;
        for (StationInfos::iterator it = stationInfos.begin(); it != stationInfos.end(); ++it)
            if (!it->location.IsZero() && (it->transports & trFilter))
            {
                int c = 0;
                if (it->curve)
                    c = it->curve->id;
                out << "[POI]\nType=" << color << "\nData0=("
                << it->location.x << "," << it->location.y
                << ")"
                << "\nLabel=" << it->name << "-" << it->id << "cn=" << c << " nc: ";
                for (size_t i = 0; i < it->neigCurves.size(); i++)
                    out << " " << it->neigCurves[i]->id;
                out << "\n[END]\n" << std::endl;
                res++;
            }
        return res;
    }


}
