#if !defined(THREAD_H)
#define THREAD_H

#include "pf.h"
#include "curve.h"
#include "stationloc.h"
#include "transport.h"
#include "dates.h"
namespace Pathfinder
{
    // нитка, идентификатор
    typedef int Thread;
    // вектор ниток
    typedef std::vector<Thread> Threads;

    class TripInfo;
    struct StationAndInfo;
    class StationRasp;
    typedef std::vector<StationRasp> Graph;

    struct ThreadStart;
    struct StationInfo;
    typedef std::vector<const StationInfo*> StationInfoPtrs;
    typedef std::map<const StationInfo*, StationInfoPtrs > Town2Stations;
    struct Route
    {
        std::string name;
        int id;
        std::vector<const ThreadStart*> threads;
        Town2Stations town2stations;
        Route(std::string n = "", int i = 0)
            : name(n), id(i) {}
        const StationInfo* town2station(const StationInfo* town) const;
    };
    typedef std::vector<Route> Routes;
    typedef std::map<std::string, int> RouteMap;

    struct ThreadStart
    {
        int id;
        std::string name;
        std::string routeName;
        const TripInfo* startTI;
        int startID;
        double moveTime;
        double stopTime;
        double len;
        int tiNumber;
        Transport::Type transports;
        //t.type_id. для всех ниток =1, для беспересадочных вагонов =3
        int mainThread;
        const Route* route;
        int interval_begin_time, interval_end_time;
        int interval_delta;
        bool loadedCorrect;
        Departures departures;
        ThreadStart() 
            : id(-1), startTI(0), startID(-1)
            , moveTime(0), stopTime(0)
            , len(0), tiNumber(0)
            , transports(Transport::NONE) 
            , mainThread(0)
            , route(0)
            , interval_begin_time(-1)
            , interval_end_time(-1)
            , interval_delta(60)
            , loadedCorrect(true)
        {}
        ThreadStart(const int thread_id, const int sid, const std::string& name0, const std::string& route0
            , const Transport::Type transport0, int mainThread0) 
            : id(thread_id), startTI(0), startID(sid)
            , moveTime(0), stopTime(0)
            , len(0), tiNumber(0)
            , transports(transport0) 
            , mainThread(mainThread0)
            , route(0)
            , interval_begin_time(-1)
            , interval_end_time(-1)
            , interval_delta(60)
            , loadedCorrect(true)
        {
            name = name0;
            routeName = route0;
        }

        inline bool isHelper() const 
        {
            return (!name.empty() && name[0] == '!');
        }
        inline bool isMain() const {return mainThread!=3;}
        inline bool isInterval() const {return mainThread==12;}

        double moveSpeed()
        {
            return len/moveTime;
        }
        double fullSpeed()
        {
            return len/(moveTime+stopTime);
        }

        int getDepartureTimeAfter(const int& departureAfter) const
        {
            if (interval_begin_time >= 0)
            {
                int day = departureAfter / MINUTES_IN_DAY;
                int dtb = -1, dte = -1;
                bool goodDay = departures.isGoodDay(day);
                if (goodDay)
                {
                    dte = day * MINUTES_IN_DAY + interval_end_time;
                    if (departureAfter > dte)
                        goodDay = false;
                    else
                    {
                        dtb = day * MINUTES_IN_DAY + interval_begin_time;
                        if (dtb >= departureAfter)
                            return dtb;
                        return std::min(departureAfter+interval_delta, dte);
                    }
                }
                if (!goodDay)
                {
                    day++;
                    goodDay = departures.isGoodDay(day);
                    if (goodDay)
                    {
                        dtb = day * MINUTES_IN_DAY + interval_begin_time;
                        return dtb;
                    }
                }
                return -1; 
            }
            return departures.getDepartureTimeAfter(departureAfter);
        }
        void updateInfo();

        const std::string& getName() const;

        void getStationsWithLocation(StationLocTimes& res);

        void interpolateStationsWithOutLocation(const StationLocTimes& res, StationLocLens& stloc);

        //здесь заполняется detailedTI
        size_t fillShortestPaths(Graph& g);

        size_t calcPathPointNumber();
        void saveAsPolish_peace(std::ostream& out, const char* color = "3328");
        void saveAsPolish(std::ostream& log, std::ostream& out, const char* color = "3328");
    };
    typedef std::vector<ThreadStart> ThreadStarts;

}
#endif

