#include "timer.h"

#if defined (_win32_) || defined (_win64_)
#   include <windows.h>
#   include <time.h>
void FileTimeToTimeval(const FILETIME *ft, timeval *tv)
{
    const i64 NANOINTERVAL = LL(116444736000000000); // Number of 100 nanosecond units from 1/1/1601 to 1/1/1970
    union
    {
        ui64 ft_scalar;
        FILETIME ft_struct;
    } nt_time;
    nt_time.ft_struct = *ft;
    tv->tv_sec = (long)((nt_time.ft_scalar - NANOINTERVAL) / LL(10000000));
    tv->tv_usec = (i32)((nt_time.ft_scalar / LL(10)) % LL(1000000));
}
// obtains the current time, expressed as seconds and microseconds since 00:00 UTC, January 1, 1970
int gettimeofday(timeval *tp, void*)
{
    FILETIME ft;
    GetSystemTimeAsFileTime(&ft);
    FileTimeToTimeval(&ft, tp);
    return 0;
}
#else
#   include <sys/time.h>
#endif

ui64 ToMicroSeconds(const struct timeval* tv)
{
    return (ui64)tv->tv_sec * (ui64)1000000 + (ui64)tv->tv_usec;
}

ui64 MicroSeconds()
{
    struct timeval tv;
    gettimeofday(&tv, 0);
    return ToMicroSeconds(&tv);
}

#ifdef _win32_
//  
void Timer::start() { time(&_start); }
// 
void Timer::stop()  { time(&_stop); }
#endif

std::string Timer::getDateTime()
{
    time_t rawtime;
    struct tm * timeinfo;
    char buffer[80];
    time(&rawtime);
    timeinfo = localtime(&rawtime);

    strftime(buffer, 80, "%Y-%m-%d %X", timeinfo);

    return std::string(buffer);
}

